/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.s3.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;

import software.amazon.awssdk.core.util.StringUtils;

/**
 * DeleteObjectRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DeleteObjectRequestMarshaller implements Marshaller<Request<DeleteObjectRequest>, DeleteObjectRequest> {

    public Request<DeleteObjectRequest> marshall(DeleteObjectRequest deleteObjectRequest) {

        if (deleteObjectRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<DeleteObjectRequest> request = new DefaultRequest<DeleteObjectRequest>(deleteObjectRequest, "S3Client");

        request.setHttpMethod(HttpMethodName.DELETE);

        if (deleteObjectRequest.mfa() != null) {
            request.addHeader("x-amz-mfa", StringUtils.fromString(deleteObjectRequest.mfa()));
        }

        if (deleteObjectRequest.requestPayerString() != null) {
            request.addHeader("x-amz-request-payer", StringUtils.fromString(deleteObjectRequest.requestPayerString()));
        }

        String uriResourcePath = "/{Bucket}/{Key+}";

        uriResourcePath = software.amazon.awssdk.core.runtime.transform.PathMarshallers.NON_GREEDY.marshall(uriResourcePath,
                "Bucket", deleteObjectRequest.bucket());
        uriResourcePath = software.amazon.awssdk.core.runtime.transform.PathMarshallers.GREEDY.marshall(uriResourcePath, "Key",
                deleteObjectRequest.key());
        request.setResourcePath(uriResourcePath);

        if (deleteObjectRequest.versionId() != null) {
            request.addParameter("versionId", StringUtils.fromString(deleteObjectRequest.versionId()));
        }

        return request;
    }

}