/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.s3.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;

import software.amazon.awssdk.core.util.StringUtils;

/**
 * CopyObjectRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CopyObjectRequestMarshaller implements Marshaller<Request<CopyObjectRequest>, CopyObjectRequest> {

    public Request<CopyObjectRequest> marshall(CopyObjectRequest copyObjectRequest) {

        if (copyObjectRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<CopyObjectRequest> request = new DefaultRequest<CopyObjectRequest>(copyObjectRequest, "S3Client");

        request.setHttpMethod(HttpMethodName.PUT);

        if (copyObjectRequest.aclString() != null) {
            request.addHeader("x-amz-acl", StringUtils.fromString(copyObjectRequest.aclString()));
        }

        if (copyObjectRequest.cacheControl() != null) {
            request.addHeader("Cache-Control", StringUtils.fromString(copyObjectRequest.cacheControl()));
        }

        if (copyObjectRequest.contentDisposition() != null) {
            request.addHeader("Content-Disposition", StringUtils.fromString(copyObjectRequest.contentDisposition()));
        }

        if (copyObjectRequest.contentEncoding() != null) {
            request.addHeader("Content-Encoding", StringUtils.fromString(copyObjectRequest.contentEncoding()));
        }

        if (copyObjectRequest.contentLanguage() != null) {
            request.addHeader("Content-Language", StringUtils.fromString(copyObjectRequest.contentLanguage()));
        }

        if (copyObjectRequest.contentType() != null) {
            request.addHeader("Content-Type", StringUtils.fromString(copyObjectRequest.contentType()));
        }

        if (copyObjectRequest.copySource() != null) {
            request.addHeader("x-amz-copy-source", StringUtils.fromString(copyObjectRequest.copySource()));
        }

        if (copyObjectRequest.copySourceIfMatch() != null) {
            request.addHeader("x-amz-copy-source-if-match", StringUtils.fromString(copyObjectRequest.copySourceIfMatch()));
        }

        if (copyObjectRequest.copySourceIfModifiedSince() != null) {
            request.addHeader("x-amz-copy-source-if-modified-since",
                    StringUtils.fromInstant(copyObjectRequest.copySourceIfModifiedSince()));
        }

        if (copyObjectRequest.copySourceIfNoneMatch() != null) {
            request.addHeader("x-amz-copy-source-if-none-match",
                    StringUtils.fromString(copyObjectRequest.copySourceIfNoneMatch()));
        }

        if (copyObjectRequest.copySourceIfUnmodifiedSince() != null) {
            request.addHeader("x-amz-copy-source-if-unmodified-since",
                    StringUtils.fromInstant(copyObjectRequest.copySourceIfUnmodifiedSince()));
        }

        if (copyObjectRequest.expires() != null) {
            request.addHeader("Expires", StringUtils.fromInstant(copyObjectRequest.expires()));
        }

        if (copyObjectRequest.grantFullControl() != null) {
            request.addHeader("x-amz-grant-full-control", StringUtils.fromString(copyObjectRequest.grantFullControl()));
        }

        if (copyObjectRequest.grantRead() != null) {
            request.addHeader("x-amz-grant-read", StringUtils.fromString(copyObjectRequest.grantRead()));
        }

        if (copyObjectRequest.grantReadACP() != null) {
            request.addHeader("x-amz-grant-read-acp", StringUtils.fromString(copyObjectRequest.grantReadACP()));
        }

        if (copyObjectRequest.grantWriteACP() != null) {
            request.addHeader("x-amz-grant-write-acp", StringUtils.fromString(copyObjectRequest.grantWriteACP()));
        }

        if (copyObjectRequest.metadataDirectiveString() != null) {
            request.addHeader("x-amz-metadata-directive", StringUtils.fromString(copyObjectRequest.metadataDirectiveString()));
        }

        if (copyObjectRequest.taggingDirectiveString() != null) {
            request.addHeader("x-amz-tagging-directive", StringUtils.fromString(copyObjectRequest.taggingDirectiveString()));
        }

        if (copyObjectRequest.serverSideEncryptionString() != null) {
            request.addHeader("x-amz-server-side-encryption",
                    StringUtils.fromString(copyObjectRequest.serverSideEncryptionString()));
        }

        if (copyObjectRequest.storageClassString() != null) {
            request.addHeader("x-amz-storage-class", StringUtils.fromString(copyObjectRequest.storageClassString()));
        }

        if (copyObjectRequest.websiteRedirectLocation() != null) {
            request.addHeader("x-amz-website-redirect-location",
                    StringUtils.fromString(copyObjectRequest.websiteRedirectLocation()));
        }

        if (copyObjectRequest.sseCustomerAlgorithm() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-algorithm",
                    StringUtils.fromString(copyObjectRequest.sseCustomerAlgorithm()));
        }

        if (copyObjectRequest.sseCustomerKey() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-key",
                    StringUtils.fromString(copyObjectRequest.sseCustomerKey()));
        }

        if (copyObjectRequest.sseCustomerKeyMD5() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-key-MD5",
                    StringUtils.fromString(copyObjectRequest.sseCustomerKeyMD5()));
        }

        if (copyObjectRequest.ssekmsKeyId() != null) {
            request.addHeader("x-amz-server-side-encryption-aws-kms-key-id",
                    StringUtils.fromString(copyObjectRequest.ssekmsKeyId()));
        }

        if (copyObjectRequest.copySourceSSECustomerAlgorithm() != null) {
            request.addHeader("x-amz-copy-source-server-side-encryption-customer-algorithm",
                    StringUtils.fromString(copyObjectRequest.copySourceSSECustomerAlgorithm()));
        }

        if (copyObjectRequest.copySourceSSECustomerKey() != null) {
            request.addHeader("x-amz-copy-source-server-side-encryption-customer-key",
                    StringUtils.fromString(copyObjectRequest.copySourceSSECustomerKey()));
        }

        if (copyObjectRequest.copySourceSSECustomerKeyMD5() != null) {
            request.addHeader("x-amz-copy-source-server-side-encryption-customer-key-MD5",
                    StringUtils.fromString(copyObjectRequest.copySourceSSECustomerKeyMD5()));
        }

        if (copyObjectRequest.requestPayerString() != null) {
            request.addHeader("x-amz-request-payer", StringUtils.fromString(copyObjectRequest.requestPayerString()));
        }

        if (copyObjectRequest.tagging() != null) {
            request.addHeader("x-amz-tagging", StringUtils.fromString(copyObjectRequest.tagging()));
        }

        if (copyObjectRequest.metadata() != null) {
            copyObjectRequest.metadata().entrySet().forEach(e -> {
                if (e.getKey().startsWith("x-amz-meta-")) {
                    request.addHeader(e.getKey(), e.getValue());
                } else {
                    request.addHeader("x-amz-meta-" + e.getKey(), e.getValue());
                }
            });
        }

        String uriResourcePath = "/{Bucket}/{Key+}";

        uriResourcePath = software.amazon.awssdk.core.runtime.transform.PathMarshallers.NON_GREEDY.marshall(uriResourcePath,
                "Bucket", copyObjectRequest.bucket());
        uriResourcePath = software.amazon.awssdk.core.runtime.transform.PathMarshallers.GREEDY.marshall(uriResourcePath, "Key",
                copyObjectRequest.key());
        request.setResourcePath(uriResourcePath);

        return request;
    }

}