/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ReplicationRule implements ToCopyableBuilder<ReplicationRule.Builder, ReplicationRule> {
    private final String id;

    private final String prefix;

    private final String status;

    private final Destination destination;

    private ReplicationRule(BuilderImpl builder) {
        this.id = builder.id;
        this.prefix = builder.prefix;
        this.status = builder.status;
        this.destination = builder.destination;
    }

    /**
     * Unique identifier for the rule. The value cannot be longer than 255 characters.
     * 
     * @return Unique identifier for the rule. The value cannot be longer than 255 characters.
     */
    public String id() {
        return id;
    }

    /**
     * Object keyname prefix identifying one or more objects to which the rule applies. Maximum prefix length can be up
     * to 1,024 characters. Overlapping prefixes are not supported.
     * 
     * @return Object keyname prefix identifying one or more objects to which the rule applies. Maximum prefix length
     *         can be up to 1,024 characters. Overlapping prefixes are not supported.
     */
    public String prefix() {
        return prefix;
    }

    /**
     * The rule is ignored if status is not Enabled.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ReplicationRuleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusString}.
     * </p>
     * 
     * @return The rule is ignored if status is not Enabled.
     * @see ReplicationRuleStatus
     */
    public ReplicationRuleStatus status() {
        return ReplicationRuleStatus.fromValue(status);
    }

    /**
     * The rule is ignored if status is not Enabled.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ReplicationRuleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusString}.
     * </p>
     * 
     * @return The rule is ignored if status is not Enabled.
     * @see ReplicationRuleStatus
     */
    public String statusString() {
        return status;
    }

    /**
     * Returns the value of the Destination property for this object.
     * 
     * @return The value of the Destination property for this object.
     */
    public Destination destination() {
        return destination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(prefix());
        hashCode = 31 * hashCode + Objects.hashCode(statusString());
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationRule)) {
            return false;
        }
        ReplicationRule other = (ReplicationRule) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(prefix(), other.prefix())
                && Objects.equals(statusString(), other.statusString()) && Objects.equals(destination(), other.destination());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (id() != null) {
            sb.append("ID: ").append(id()).append(",");
        }
        if (prefix() != null) {
            sb.append("Prefix: ").append(prefix()).append(",");
        }
        if (statusString() != null) {
            sb.append("Status: ").append(statusString()).append(",");
        }
        if (destination() != null) {
            sb.append("Destination: ").append(destination()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ID":
            return Optional.of(clazz.cast(id()));
        case "Prefix":
            return Optional.of(clazz.cast(prefix()));
        case "Status":
            return Optional.of(clazz.cast(statusString()));
        case "Destination":
            return Optional.of(clazz.cast(destination()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ReplicationRule> {
        /**
         * Unique identifier for the rule. The value cannot be longer than 255 characters.
         * 
         * @param id
         *        Unique identifier for the rule. The value cannot be longer than 255 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * Object keyname prefix identifying one or more objects to which the rule applies. Maximum prefix length can be
         * up to 1,024 characters. Overlapping prefixes are not supported.
         * 
         * @param prefix
         *        Object keyname prefix identifying one or more objects to which the rule applies. Maximum prefix length
         *        can be up to 1,024 characters. Overlapping prefixes are not supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);

        /**
         * The rule is ignored if status is not Enabled.
         * 
         * @param status
         *        The rule is ignored if status is not Enabled.
         * @see ReplicationRuleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicationRuleStatus
         */
        Builder status(String status);

        /**
         * The rule is ignored if status is not Enabled.
         * 
         * @param status
         *        The rule is ignored if status is not Enabled.
         * @see ReplicationRuleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicationRuleStatus
         */
        Builder status(ReplicationRuleStatus status);

        /**
         * Sets the value of the Destination property for this object.
         *
         * @param destination
         *        The new value for the Destination property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(Destination destination);

        /**
         * Sets the value of the Destination property for this object.
         *
         * This is a convenience that creates an instance of the {@link Destination.Builder} avoiding the need to create
         * one manually via {@link Destination#builder()}.
         *
         * When the {@link Consumer} completes, {@link Destination.Builder#build()} is called immediately and its result
         * is passed to {@link #destination(Destination)}.
         * 
         * @param destination
         *        a consumer that will call methods on {@link Destination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destination(Destination)
         */
        default Builder destination(Consumer<Destination.Builder> destination) {
            return destination(Destination.builder().apply(destination).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String prefix;

        private String status;

        private Destination destination;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationRule model) {
            id(model.id);
            prefix(model.prefix);
            status(model.status);
            destination(model.destination);
        }

        public final String getID() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setID(String id) {
            this.id = id;
        }

        public final String getPrefix() {
            return prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ReplicationRuleStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Destination.Builder getDestination() {
            return destination != null ? destination.toBuilder() : null;
        }

        @Override
        public final Builder destination(Destination destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(Destination.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        public ReplicationRule build() {
            return new ReplicationRule(this);
        }
    }
}
