/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class PutBucketWebsiteRequest extends S3Request implements
        ToCopyableBuilder<PutBucketWebsiteRequest.Builder, PutBucketWebsiteRequest> {
    private final String bucket;

    private final String contentMD5;

    private final WebsiteConfiguration websiteConfiguration;

    private PutBucketWebsiteRequest(BuilderImpl builder) {
        super(builder);
        this.bucket = builder.bucket;
        this.contentMD5 = builder.contentMD5;
        this.websiteConfiguration = builder.websiteConfiguration;
    }

    /**
     * Returns the value of the Bucket property for this object.
     * 
     * @return The value of the Bucket property for this object.
     */
    public String bucket() {
        return bucket;
    }

    /**
     * Returns the value of the ContentMD5 property for this object.
     * 
     * @return The value of the ContentMD5 property for this object.
     */
    public String contentMD5() {
        return contentMD5;
    }

    /**
     * Returns the value of the WebsiteConfiguration property for this object.
     * 
     * @return The value of the WebsiteConfiguration property for this object.
     */
    public WebsiteConfiguration websiteConfiguration() {
        return websiteConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucket());
        hashCode = 31 * hashCode + Objects.hashCode(contentMD5());
        hashCode = 31 * hashCode + Objects.hashCode(websiteConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutBucketWebsiteRequest)) {
            return false;
        }
        PutBucketWebsiteRequest other = (PutBucketWebsiteRequest) obj;
        return Objects.equals(bucket(), other.bucket()) && Objects.equals(contentMD5(), other.contentMD5())
                && Objects.equals(websiteConfiguration(), other.websiteConfiguration());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (bucket() != null) {
            sb.append("Bucket: ").append(bucket()).append(",");
        }
        if (contentMD5() != null) {
            sb.append("ContentMD5: ").append(contentMD5()).append(",");
        }
        if (websiteConfiguration() != null) {
            sb.append("WebsiteConfiguration: ").append(websiteConfiguration()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Bucket":
            return Optional.of(clazz.cast(bucket()));
        case "ContentMD5":
            return Optional.of(clazz.cast(contentMD5()));
        case "WebsiteConfiguration":
            return Optional.of(clazz.cast(websiteConfiguration()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends S3Request.Builder, CopyableBuilder<Builder, PutBucketWebsiteRequest> {
        /**
         * Sets the value of the Bucket property for this object.
         *
         * @param bucket
         *        The new value for the Bucket property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * Sets the value of the ContentMD5 property for this object.
         *
         * @param contentMD5
         *        The new value for the ContentMD5 property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentMD5(String contentMD5);

        /**
         * Sets the value of the WebsiteConfiguration property for this object.
         *
         * @param websiteConfiguration
         *        The new value for the WebsiteConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder websiteConfiguration(WebsiteConfiguration websiteConfiguration);

        /**
         * Sets the value of the WebsiteConfiguration property for this object.
         *
         * This is a convenience that creates an instance of the {@link WebsiteConfiguration.Builder} avoiding the need
         * to create one manually via {@link WebsiteConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link WebsiteConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #websiteConfiguration(WebsiteConfiguration)}.
         * 
         * @param websiteConfiguration
         *        a consumer that will call methods on {@link WebsiteConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #websiteConfiguration(WebsiteConfiguration)
         */
        default Builder websiteConfiguration(Consumer<WebsiteConfiguration.Builder> websiteConfiguration) {
            return websiteConfiguration(WebsiteConfiguration.builder().apply(websiteConfiguration).build());
        }

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends S3Request.BuilderImpl implements Builder {
        private String bucket;

        private String contentMD5;

        private WebsiteConfiguration websiteConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PutBucketWebsiteRequest model) {
            bucket(model.bucket);
            contentMD5(model.contentMD5);
            websiteConfiguration(model.websiteConfiguration);
        }

        public final String getBucket() {
            return bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getContentMD5() {
            return contentMD5;
        }

        @Override
        public final Builder contentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
            return this;
        }

        public final void setContentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
        }

        public final WebsiteConfiguration.Builder getWebsiteConfiguration() {
            return websiteConfiguration != null ? websiteConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder websiteConfiguration(WebsiteConfiguration websiteConfiguration) {
            this.websiteConfiguration = websiteConfiguration;
            return this;
        }

        public final void setWebsiteConfiguration(WebsiteConfiguration.BuilderImpl websiteConfiguration) {
            this.websiteConfiguration = websiteConfiguration != null ? websiteConfiguration.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public PutBucketWebsiteRequest build() {
            return new PutBucketWebsiteRequest(this);
        }
    }
}
