/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class PutBucketMetricsConfigurationRequest extends S3Request implements
        ToCopyableBuilder<PutBucketMetricsConfigurationRequest.Builder, PutBucketMetricsConfigurationRequest> {
    private final String bucket;

    private final String id;

    private final MetricsConfiguration metricsConfiguration;

    private PutBucketMetricsConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.bucket = builder.bucket;
        this.id = builder.id;
        this.metricsConfiguration = builder.metricsConfiguration;
    }

    /**
     * The name of the bucket for which the metrics configuration is set.
     * 
     * @return The name of the bucket for which the metrics configuration is set.
     */
    public String bucket() {
        return bucket;
    }

    /**
     * The ID used to identify the metrics configuration.
     * 
     * @return The ID used to identify the metrics configuration.
     */
    public String id() {
        return id;
    }

    /**
     * Specifies the metrics configuration.
     * 
     * @return Specifies the metrics configuration.
     */
    public MetricsConfiguration metricsConfiguration() {
        return metricsConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucket());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(metricsConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutBucketMetricsConfigurationRequest)) {
            return false;
        }
        PutBucketMetricsConfigurationRequest other = (PutBucketMetricsConfigurationRequest) obj;
        return Objects.equals(bucket(), other.bucket()) && Objects.equals(id(), other.id())
                && Objects.equals(metricsConfiguration(), other.metricsConfiguration());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (bucket() != null) {
            sb.append("Bucket: ").append(bucket()).append(",");
        }
        if (id() != null) {
            sb.append("Id: ").append(id()).append(",");
        }
        if (metricsConfiguration() != null) {
            sb.append("MetricsConfiguration: ").append(metricsConfiguration()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Bucket":
            return Optional.of(clazz.cast(bucket()));
        case "Id":
            return Optional.of(clazz.cast(id()));
        case "MetricsConfiguration":
            return Optional.of(clazz.cast(metricsConfiguration()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends S3Request.Builder, CopyableBuilder<Builder, PutBucketMetricsConfigurationRequest> {
        /**
         * The name of the bucket for which the metrics configuration is set.
         * 
         * @param bucket
         *        The name of the bucket for which the metrics configuration is set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * The ID used to identify the metrics configuration.
         * 
         * @param id
         *        The ID used to identify the metrics configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * Specifies the metrics configuration.
         * 
         * @param metricsConfiguration
         *        Specifies the metrics configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricsConfiguration(MetricsConfiguration metricsConfiguration);

        /**
         * Specifies the metrics configuration. This is a convenience that creates an instance of the
         * {@link MetricsConfiguration.Builder} avoiding the need to create one manually via
         * {@link MetricsConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link MetricsConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #metricsConfiguration(MetricsConfiguration)}.
         * 
         * @param metricsConfiguration
         *        a consumer that will call methods on {@link MetricsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricsConfiguration(MetricsConfiguration)
         */
        default Builder metricsConfiguration(Consumer<MetricsConfiguration.Builder> metricsConfiguration) {
            return metricsConfiguration(MetricsConfiguration.builder().apply(metricsConfiguration).build());
        }

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends S3Request.BuilderImpl implements Builder {
        private String bucket;

        private String id;

        private MetricsConfiguration metricsConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PutBucketMetricsConfigurationRequest model) {
            bucket(model.bucket);
            id(model.id);
            metricsConfiguration(model.metricsConfiguration);
        }

        public final String getBucket() {
            return bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final MetricsConfiguration.Builder getMetricsConfiguration() {
            return metricsConfiguration != null ? metricsConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder metricsConfiguration(MetricsConfiguration metricsConfiguration) {
            this.metricsConfiguration = metricsConfiguration;
            return this;
        }

        public final void setMetricsConfiguration(MetricsConfiguration.BuilderImpl metricsConfiguration) {
            this.metricsConfiguration = metricsConfiguration != null ? metricsConfiguration.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public PutBucketMetricsConfigurationRequest build() {
            return new PutBucketMetricsConfigurationRequest(this);
        }
    }
}
