/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class Initiator implements ToCopyableBuilder<Initiator.Builder, Initiator> {
    private final String id;

    private final String displayName;

    private Initiator(BuilderImpl builder) {
        this.id = builder.id;
        this.displayName = builder.displayName;
    }

    /**
     * If the principal is an AWS account, it provides the Canonical User ID. If the principal is an IAM User, it
     * provides a user ARN value.
     * 
     * @return If the principal is an AWS account, it provides the Canonical User ID. If the principal is an IAM User,
     *         it provides a user ARN value.
     */
    public String id() {
        return id;
    }

    /**
     * Name of the Principal.
     * 
     * @return Name of the Principal.
     */
    public String displayName() {
        return displayName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Initiator)) {
            return false;
        }
        Initiator other = (Initiator) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(displayName(), other.displayName());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (id() != null) {
            sb.append("ID: ").append(id()).append(",");
        }
        if (displayName() != null) {
            sb.append("DisplayName: ").append(displayName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ID":
            return Optional.of(clazz.cast(id()));
        case "DisplayName":
            return Optional.of(clazz.cast(displayName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, Initiator> {
        /**
         * If the principal is an AWS account, it provides the Canonical User ID. If the principal is an IAM User, it
         * provides a user ARN value.
         * 
         * @param id
         *        If the principal is an AWS account, it provides the Canonical User ID. If the principal is an IAM
         *        User, it provides a user ARN value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * Name of the Principal.
         * 
         * @param displayName
         *        Name of the Principal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String displayName;

        private BuilderImpl() {
        }

        private BuilderImpl(Initiator model) {
            id(model.id);
            displayName(model.displayName);
        }

        public final String getID() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setID(String id) {
            this.id = id;
        }

        public final String getDisplayName() {
            return displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public Initiator build() {
            return new Initiator(this);
        }
    }
}
