/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Container for key value pair that defines the criteria for the filter rule.
 */
@Generated("software.amazon.awssdk:codegen")
public class FilterRule implements ToCopyableBuilder<FilterRule.Builder, FilterRule> {
    private final String name;

    private final String value;

    private FilterRule(BuilderImpl builder) {
        this.name = builder.name;
        this.value = builder.value;
    }

    /**
     * Object key name prefix or suffix identifying one or more objects to which the filtering rule applies. Maximum
     * prefix length can be up to 1,024 characters. Overlapping prefixes and suffixes are not supported. For more
     * information, go to <a href="http://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Configuring
     * Event Notifications</a> in the Amazon Simple Storage Service Developer Guide.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link FilterRuleName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameString}.
     * </p>
     * 
     * @return Object key name prefix or suffix identifying one or more objects to which the filtering rule applies.
     *         Maximum prefix length can be up to 1,024 characters. Overlapping prefixes and suffixes are not supported.
     *         For more information, go to <a
     *         href="http://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Configuring Event
     *         Notifications</a> in the Amazon Simple Storage Service Developer Guide.
     * @see FilterRuleName
     */
    public FilterRuleName name() {
        return FilterRuleName.fromValue(name);
    }

    /**
     * Object key name prefix or suffix identifying one or more objects to which the filtering rule applies. Maximum
     * prefix length can be up to 1,024 characters. Overlapping prefixes and suffixes are not supported. For more
     * information, go to <a href="http://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Configuring
     * Event Notifications</a> in the Amazon Simple Storage Service Developer Guide.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link FilterRuleName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameString}.
     * </p>
     * 
     * @return Object key name prefix or suffix identifying one or more objects to which the filtering rule applies.
     *         Maximum prefix length can be up to 1,024 characters. Overlapping prefixes and suffixes are not supported.
     *         For more information, go to <a
     *         href="http://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Configuring Event
     *         Notifications</a> in the Amazon Simple Storage Service Developer Guide.
     * @see FilterRuleName
     */
    public String nameString() {
        return name;
    }

    /**
     * Returns the value of the Value property for this object.
     * 
     * @return The value of the Value property for this object.
     */
    public String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nameString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterRule)) {
            return false;
        }
        FilterRule other = (FilterRule) obj;
        return Objects.equals(nameString(), other.nameString()) && Objects.equals(value(), other.value());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (nameString() != null) {
            sb.append("Name: ").append(nameString()).append(",");
        }
        if (value() != null) {
            sb.append("Value: ").append(value()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.of(clazz.cast(nameString()));
        case "Value":
            return Optional.of(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, FilterRule> {
        /**
         * Object key name prefix or suffix identifying one or more objects to which the filtering rule applies. Maximum
         * prefix length can be up to 1,024 characters. Overlapping prefixes and suffixes are not supported. For more
         * information, go to <a
         * href="http://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Configuring Event
         * Notifications</a> in the Amazon Simple Storage Service Developer Guide.
         * 
         * @param name
         *        Object key name prefix or suffix identifying one or more objects to which the filtering rule applies.
         *        Maximum prefix length can be up to 1,024 characters. Overlapping prefixes and suffixes are not
         *        supported. For more information, go to <a
         *        href="http://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Configuring Event
         *        Notifications</a> in the Amazon Simple Storage Service Developer Guide.
         * @see FilterRuleName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterRuleName
         */
        Builder name(String name);

        /**
         * Object key name prefix or suffix identifying one or more objects to which the filtering rule applies. Maximum
         * prefix length can be up to 1,024 characters. Overlapping prefixes and suffixes are not supported. For more
         * information, go to <a
         * href="http://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Configuring Event
         * Notifications</a> in the Amazon Simple Storage Service Developer Guide.
         * 
         * @param name
         *        Object key name prefix or suffix identifying one or more objects to which the filtering rule applies.
         *        Maximum prefix length can be up to 1,024 characters. Overlapping prefixes and suffixes are not
         *        supported. For more information, go to <a
         *        href="http://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Configuring Event
         *        Notifications</a> in the Amazon Simple Storage Service Developer Guide.
         * @see FilterRuleName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterRuleName
         */
        Builder name(FilterRuleName name);

        /**
         * Sets the value of the Value property for this object.
         *
         * @param value
         *        The new value for the Value property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(FilterRule model) {
            name(model.name);
            value(model.value);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(FilterRuleName name) {
            this.name(name.toString());
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getValue() {
            return value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public FilterRule build() {
            return new FilterRule(this);
        }
    }
}
