/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CopyObjectResponse extends S3Response implements ToCopyableBuilder<CopyObjectResponse.Builder, CopyObjectResponse> {
    private final CopyObjectResult copyObjectResult;

    private final String expiration;

    private final String copySourceVersionId;

    private final String versionId;

    private final String serverSideEncryption;

    private final String sseCustomerAlgorithm;

    private final String sseCustomerKeyMD5;

    private final String ssekmsKeyId;

    private final String requestCharged;

    private CopyObjectResponse(BuilderImpl builder) {
        super(builder);
        this.copyObjectResult = builder.copyObjectResult;
        this.expiration = builder.expiration;
        this.copySourceVersionId = builder.copySourceVersionId;
        this.versionId = builder.versionId;
        this.serverSideEncryption = builder.serverSideEncryption;
        this.sseCustomerAlgorithm = builder.sseCustomerAlgorithm;
        this.sseCustomerKeyMD5 = builder.sseCustomerKeyMD5;
        this.ssekmsKeyId = builder.ssekmsKeyId;
        this.requestCharged = builder.requestCharged;
    }

    /**
     * Returns the value of the CopyObjectResult property for this object.
     * 
     * @return The value of the CopyObjectResult property for this object.
     */
    public CopyObjectResult copyObjectResult() {
        return copyObjectResult;
    }

    /**
     * If the object expiration is configured, the response includes this header.
     * 
     * @return If the object expiration is configured, the response includes this header.
     */
    public String expiration() {
        return expiration;
    }

    /**
     * Returns the value of the CopySourceVersionId property for this object.
     * 
     * @return The value of the CopySourceVersionId property for this object.
     */
    public String copySourceVersionId() {
        return copySourceVersionId;
    }

    /**
     * Version ID of the newly created copy.
     * 
     * @return Version ID of the newly created copy.
     */
    public String versionId() {
        return versionId;
    }

    /**
     * The Server-side encryption algorithm used when storing this object in S3 (e.g., AES256, aws:kms).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #serverSideEncryption} will return {@link ServerSideEncryption#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #serverSideEncryptionString}.
     * </p>
     * 
     * @return The Server-side encryption algorithm used when storing this object in S3 (e.g., AES256, aws:kms).
     * @see ServerSideEncryption
     */
    public ServerSideEncryption serverSideEncryption() {
        return ServerSideEncryption.fromValue(serverSideEncryption);
    }

    /**
     * The Server-side encryption algorithm used when storing this object in S3 (e.g., AES256, aws:kms).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #serverSideEncryption} will return {@link ServerSideEncryption#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #serverSideEncryptionString}.
     * </p>
     * 
     * @return The Server-side encryption algorithm used when storing this object in S3 (e.g., AES256, aws:kms).
     * @see ServerSideEncryption
     */
    public String serverSideEncryptionString() {
        return serverSideEncryption;
    }

    /**
     * If server-side encryption with a customer-provided encryption key was requested, the response will include this
     * header confirming the encryption algorithm used.
     * 
     * @return If server-side encryption with a customer-provided encryption key was requested, the response will
     *         include this header confirming the encryption algorithm used.
     */
    public String sseCustomerAlgorithm() {
        return sseCustomerAlgorithm;
    }

    /**
     * If server-side encryption with a customer-provided encryption key was requested, the response will include this
     * header to provide round trip message integrity verification of the customer-provided encryption key.
     * 
     * @return If server-side encryption with a customer-provided encryption key was requested, the response will
     *         include this header to provide round trip message integrity verification of the customer-provided
     *         encryption key.
     */
    public String sseCustomerKeyMD5() {
        return sseCustomerKeyMD5;
    }

    /**
     * If present, specifies the ID of the AWS Key Management Service (KMS) master encryption key that was used for the
     * object.
     * 
     * @return If present, specifies the ID of the AWS Key Management Service (KMS) master encryption key that was used
     *         for the object.
     */
    public String ssekmsKeyId() {
        return ssekmsKeyId;
    }

    /**
     * Returns the value of the RequestCharged property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #requestCharged}
     * will return {@link RequestCharged#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #requestChargedString}.
     * </p>
     * 
     * @return The value of the RequestCharged property for this object.
     * @see RequestCharged
     */
    public RequestCharged requestCharged() {
        return RequestCharged.fromValue(requestCharged);
    }

    /**
     * Returns the value of the RequestCharged property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #requestCharged}
     * will return {@link RequestCharged#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #requestChargedString}.
     * </p>
     * 
     * @return The value of the RequestCharged property for this object.
     * @see RequestCharged
     */
    public String requestChargedString() {
        return requestCharged;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(copyObjectResult());
        hashCode = 31 * hashCode + Objects.hashCode(expiration());
        hashCode = 31 * hashCode + Objects.hashCode(copySourceVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(versionId());
        hashCode = 31 * hashCode + Objects.hashCode(serverSideEncryptionString());
        hashCode = 31 * hashCode + Objects.hashCode(sseCustomerAlgorithm());
        hashCode = 31 * hashCode + Objects.hashCode(sseCustomerKeyMD5());
        hashCode = 31 * hashCode + Objects.hashCode(ssekmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(requestChargedString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyObjectResponse)) {
            return false;
        }
        CopyObjectResponse other = (CopyObjectResponse) obj;
        return Objects.equals(copyObjectResult(), other.copyObjectResult()) && Objects.equals(expiration(), other.expiration())
                && Objects.equals(copySourceVersionId(), other.copySourceVersionId())
                && Objects.equals(versionId(), other.versionId())
                && Objects.equals(serverSideEncryptionString(), other.serverSideEncryptionString())
                && Objects.equals(sseCustomerAlgorithm(), other.sseCustomerAlgorithm())
                && Objects.equals(sseCustomerKeyMD5(), other.sseCustomerKeyMD5())
                && Objects.equals(ssekmsKeyId(), other.ssekmsKeyId())
                && Objects.equals(requestChargedString(), other.requestChargedString());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (copyObjectResult() != null) {
            sb.append("CopyObjectResult: ").append(copyObjectResult()).append(",");
        }
        if (expiration() != null) {
            sb.append("Expiration: ").append(expiration()).append(",");
        }
        if (copySourceVersionId() != null) {
            sb.append("CopySourceVersionId: ").append(copySourceVersionId()).append(",");
        }
        if (versionId() != null) {
            sb.append("VersionId: ").append(versionId()).append(",");
        }
        if (serverSideEncryptionString() != null) {
            sb.append("ServerSideEncryption: ").append(serverSideEncryptionString()).append(",");
        }
        if (sseCustomerAlgorithm() != null) {
            sb.append("SSECustomerAlgorithm: ").append(sseCustomerAlgorithm()).append(",");
        }
        if (sseCustomerKeyMD5() != null) {
            sb.append("SSECustomerKeyMD5: ").append(sseCustomerKeyMD5()).append(",");
        }
        if (ssekmsKeyId() != null) {
            sb.append("SSEKMSKeyId: ").append(ssekmsKeyId()).append(",");
        }
        if (requestChargedString() != null) {
            sb.append("RequestCharged: ").append(requestChargedString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CopyObjectResult":
            return Optional.of(clazz.cast(copyObjectResult()));
        case "Expiration":
            return Optional.of(clazz.cast(expiration()));
        case "CopySourceVersionId":
            return Optional.of(clazz.cast(copySourceVersionId()));
        case "VersionId":
            return Optional.of(clazz.cast(versionId()));
        case "ServerSideEncryption":
            return Optional.of(clazz.cast(serverSideEncryptionString()));
        case "SSECustomerAlgorithm":
            return Optional.of(clazz.cast(sseCustomerAlgorithm()));
        case "SSECustomerKeyMD5":
            return Optional.of(clazz.cast(sseCustomerKeyMD5()));
        case "SSEKMSKeyId":
            return Optional.of(clazz.cast(ssekmsKeyId()));
        case "RequestCharged":
            return Optional.of(clazz.cast(requestChargedString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends S3Response.Builder, CopyableBuilder<Builder, CopyObjectResponse> {
        /**
         * Sets the value of the CopyObjectResult property for this object.
         *
         * @param copyObjectResult
         *        The new value for the CopyObjectResult property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyObjectResult(CopyObjectResult copyObjectResult);

        /**
         * Sets the value of the CopyObjectResult property for this object.
         *
         * This is a convenience that creates an instance of the {@link CopyObjectResult.Builder} avoiding the need to
         * create one manually via {@link CopyObjectResult#builder()}.
         *
         * When the {@link Consumer} completes, {@link CopyObjectResult.Builder#build()} is called immediately and its
         * result is passed to {@link #copyObjectResult(CopyObjectResult)}.
         * 
         * @param copyObjectResult
         *        a consumer that will call methods on {@link CopyObjectResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #copyObjectResult(CopyObjectResult)
         */
        default Builder copyObjectResult(Consumer<CopyObjectResult.Builder> copyObjectResult) {
            return copyObjectResult(CopyObjectResult.builder().apply(copyObjectResult).build());
        }

        /**
         * If the object expiration is configured, the response includes this header.
         * 
         * @param expiration
         *        If the object expiration is configured, the response includes this header.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiration(String expiration);

        /**
         * Sets the value of the CopySourceVersionId property for this object.
         *
         * @param copySourceVersionId
         *        The new value for the CopySourceVersionId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copySourceVersionId(String copySourceVersionId);

        /**
         * Version ID of the newly created copy.
         * 
         * @param versionId
         *        Version ID of the newly created copy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionId(String versionId);

        /**
         * The Server-side encryption algorithm used when storing this object in S3 (e.g., AES256, aws:kms).
         * 
         * @param serverSideEncryption
         *        The Server-side encryption algorithm used when storing this object in S3 (e.g., AES256, aws:kms).
         * @see ServerSideEncryption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServerSideEncryption
         */
        Builder serverSideEncryption(String serverSideEncryption);

        /**
         * The Server-side encryption algorithm used when storing this object in S3 (e.g., AES256, aws:kms).
         * 
         * @param serverSideEncryption
         *        The Server-side encryption algorithm used when storing this object in S3 (e.g., AES256, aws:kms).
         * @see ServerSideEncryption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServerSideEncryption
         */
        Builder serverSideEncryption(ServerSideEncryption serverSideEncryption);

        /**
         * If server-side encryption with a customer-provided encryption key was requested, the response will include
         * this header confirming the encryption algorithm used.
         * 
         * @param sseCustomerAlgorithm
         *        If server-side encryption with a customer-provided encryption key was requested, the response will
         *        include this header confirming the encryption algorithm used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sseCustomerAlgorithm(String sseCustomerAlgorithm);

        /**
         * If server-side encryption with a customer-provided encryption key was requested, the response will include
         * this header to provide round trip message integrity verification of the customer-provided encryption key.
         * 
         * @param sseCustomerKeyMD5
         *        If server-side encryption with a customer-provided encryption key was requested, the response will
         *        include this header to provide round trip message integrity verification of the customer-provided
         *        encryption key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sseCustomerKeyMD5(String sseCustomerKeyMD5);

        /**
         * If present, specifies the ID of the AWS Key Management Service (KMS) master encryption key that was used for
         * the object.
         * 
         * @param ssekmsKeyId
         *        If present, specifies the ID of the AWS Key Management Service (KMS) master encryption key that was
         *        used for the object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ssekmsKeyId(String ssekmsKeyId);

        /**
         * Sets the value of the RequestCharged property for this object.
         *
         * @param requestCharged
         *        The new value for the RequestCharged property for this object.
         * @see RequestCharged
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequestCharged
         */
        Builder requestCharged(String requestCharged);

        /**
         * Sets the value of the RequestCharged property for this object.
         *
         * @param requestCharged
         *        The new value for the RequestCharged property for this object.
         * @see RequestCharged
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequestCharged
         */
        Builder requestCharged(RequestCharged requestCharged);
    }

    static final class BuilderImpl extends S3Response.BuilderImpl implements Builder {
        private CopyObjectResult copyObjectResult;

        private String expiration;

        private String copySourceVersionId;

        private String versionId;

        private String serverSideEncryption;

        private String sseCustomerAlgorithm;

        private String sseCustomerKeyMD5;

        private String ssekmsKeyId;

        private String requestCharged;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyObjectResponse model) {
            copyObjectResult(model.copyObjectResult);
            expiration(model.expiration);
            copySourceVersionId(model.copySourceVersionId);
            versionId(model.versionId);
            serverSideEncryption(model.serverSideEncryption);
            sseCustomerAlgorithm(model.sseCustomerAlgorithm);
            sseCustomerKeyMD5(model.sseCustomerKeyMD5);
            ssekmsKeyId(model.ssekmsKeyId);
            requestCharged(model.requestCharged);
        }

        public final CopyObjectResult.Builder getCopyObjectResult() {
            return copyObjectResult != null ? copyObjectResult.toBuilder() : null;
        }

        @Override
        public final Builder copyObjectResult(CopyObjectResult copyObjectResult) {
            this.copyObjectResult = copyObjectResult;
            return this;
        }

        public final void setCopyObjectResult(CopyObjectResult.BuilderImpl copyObjectResult) {
            this.copyObjectResult = copyObjectResult != null ? copyObjectResult.build() : null;
        }

        public final String getExpiration() {
            return expiration;
        }

        @Override
        public final Builder expiration(String expiration) {
            this.expiration = expiration;
            return this;
        }

        public final void setExpiration(String expiration) {
            this.expiration = expiration;
        }

        public final String getCopySourceVersionId() {
            return copySourceVersionId;
        }

        @Override
        public final Builder copySourceVersionId(String copySourceVersionId) {
            this.copySourceVersionId = copySourceVersionId;
            return this;
        }

        public final void setCopySourceVersionId(String copySourceVersionId) {
            this.copySourceVersionId = copySourceVersionId;
        }

        public final String getVersionId() {
            return versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        public final String getServerSideEncryption() {
            return serverSideEncryption;
        }

        @Override
        public final Builder serverSideEncryption(String serverSideEncryption) {
            this.serverSideEncryption = serverSideEncryption;
            return this;
        }

        @Override
        public final Builder serverSideEncryption(ServerSideEncryption serverSideEncryption) {
            this.serverSideEncryption(serverSideEncryption.toString());
            return this;
        }

        public final void setServerSideEncryption(String serverSideEncryption) {
            this.serverSideEncryption = serverSideEncryption;
        }

        public final String getSSECustomerAlgorithm() {
            return sseCustomerAlgorithm;
        }

        @Override
        public final Builder sseCustomerAlgorithm(String sseCustomerAlgorithm) {
            this.sseCustomerAlgorithm = sseCustomerAlgorithm;
            return this;
        }

        public final void setSSECustomerAlgorithm(String sseCustomerAlgorithm) {
            this.sseCustomerAlgorithm = sseCustomerAlgorithm;
        }

        public final String getSSECustomerKeyMD5() {
            return sseCustomerKeyMD5;
        }

        @Override
        public final Builder sseCustomerKeyMD5(String sseCustomerKeyMD5) {
            this.sseCustomerKeyMD5 = sseCustomerKeyMD5;
            return this;
        }

        public final void setSSECustomerKeyMD5(String sseCustomerKeyMD5) {
            this.sseCustomerKeyMD5 = sseCustomerKeyMD5;
        }

        public final String getSSEKMSKeyId() {
            return ssekmsKeyId;
        }

        @Override
        public final Builder ssekmsKeyId(String ssekmsKeyId) {
            this.ssekmsKeyId = ssekmsKeyId;
            return this;
        }

        public final void setSSEKMSKeyId(String ssekmsKeyId) {
            this.ssekmsKeyId = ssekmsKeyId;
        }

        public final String getRequestCharged() {
            return requestCharged;
        }

        @Override
        public final Builder requestCharged(String requestCharged) {
            this.requestCharged = requestCharged;
            return this;
        }

        @Override
        public final Builder requestCharged(RequestCharged requestCharged) {
            this.requestCharged(requestCharged.toString());
            return this;
        }

        public final void setRequestCharged(String requestCharged) {
            this.requestCharged = requestCharged;
        }

        @Override
        public CopyObjectResponse build() {
            return new CopyObjectResponse(this);
        }
    }
}
