/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshallers;
import software.amazon.awssdk.core.util.Md5Utils;
import software.amazon.awssdk.core.util.StringInputStream;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.core.util.UriResourcePathUtils;
import software.amazon.awssdk.core.util.XmlWriter;
import software.amazon.awssdk.services.s3.model.AccessControlPolicy;
import software.amazon.awssdk.services.s3.model.Grant;
import software.amazon.awssdk.services.s3.model.Grantee;
import software.amazon.awssdk.services.s3.model.Owner;
import software.amazon.awssdk.services.s3.model.PutBucketAclRequest;

public class PutBucketAclRequestMarshaller
implements Marshaller<Request<PutBucketAclRequest>, PutBucketAclRequest> {
    public Request<PutBucketAclRequest> marshall(PutBucketAclRequest putBucketAclRequest) {
        if (putBucketAclRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putBucketAclRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.PUT);
        if (putBucketAclRequest.aclString() != null) {
            request.addHeader("x-amz-acl", StringUtils.fromString((String)putBucketAclRequest.aclString()));
        }
        if (putBucketAclRequest.contentMD5() != null) {
            request.addHeader("Content-MD5", StringUtils.fromString((String)putBucketAclRequest.contentMD5()));
        }
        if (putBucketAclRequest.grantFullControl() != null) {
            request.addHeader("x-amz-grant-full-control", StringUtils.fromString((String)putBucketAclRequest.grantFullControl()));
        }
        if (putBucketAclRequest.grantRead() != null) {
            request.addHeader("x-amz-grant-read", StringUtils.fromString((String)putBucketAclRequest.grantRead()));
        }
        if (putBucketAclRequest.grantReadACP() != null) {
            request.addHeader("x-amz-grant-read-acp", StringUtils.fromString((String)putBucketAclRequest.grantReadACP()));
        }
        if (putBucketAclRequest.grantWrite() != null) {
            request.addHeader("x-amz-grant-write", StringUtils.fromString((String)putBucketAclRequest.grantWrite()));
        }
        if (putBucketAclRequest.grantWriteACP() != null) {
            request.addHeader("x-amz-grant-write-acp", StringUtils.fromString((String)putBucketAclRequest.grantWriteACP()));
        }
        String uriResourcePath = "/{Bucket}?acl";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParametersToRequest((Request)request, (String)uriResourcePath);
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", putBucketAclRequest.bucket());
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = null;
            AccessControlPolicy accessControlPolicy = putBucketAclRequest.accessControlPolicy();
            if (accessControlPolicy != null) {
                Owner owner;
                stringWriter = new StringWriter();
                XmlWriter xmlWriter = new XmlWriter((Writer)stringWriter, "http://s3.amazonaws.com/doc/2006-03-01/");
                xmlWriter.startElement("AccessControlPolicy");
                List<Grant> accessControlPolicyGrantsList = accessControlPolicy.grants();
                if (accessControlPolicyGrantsList != null) {
                    xmlWriter.startElement("AccessControlList");
                    for (Grant accessControlPolicyGrantsListValue : accessControlPolicyGrantsList) {
                        xmlWriter.startElement("Grant");
                        Grantee grantee = accessControlPolicyGrantsListValue.grantee();
                        if (grantee != null) {
                            xmlWriter.startElement("Grantee");
                            if (grantee.displayName() != null) {
                                xmlWriter.startElement("DisplayName").value(grantee.displayName()).endElement();
                            }
                            if (grantee.emailAddress() != null) {
                                xmlWriter.startElement("EmailAddress").value(grantee.emailAddress()).endElement();
                            }
                            if (grantee.id() != null) {
                                xmlWriter.startElement("ID").value(grantee.id()).endElement();
                            }
                            if (grantee.typeString() != null) {
                                xmlWriter.startElement("xsi:type").value(grantee.typeString()).endElement();
                            }
                            if (grantee.uri() != null) {
                                xmlWriter.startElement("URI").value(grantee.uri()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        if (accessControlPolicyGrantsListValue.permissionString() != null) {
                            xmlWriter.startElement("Permission").value(accessControlPolicyGrantsListValue.permissionString()).endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                if ((owner = accessControlPolicy.owner()) != null) {
                    xmlWriter.startElement("Owner");
                    if (owner.displayName() != null) {
                        xmlWriter.startElement("DisplayName").value(owner.displayName()).endElement();
                    }
                    if (owner.id() != null) {
                        xmlWriter.startElement("ID").value(owner.id()).endElement();
                    }
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }
            if (stringWriter != null) {
                if (!request.getHeaders().containsKey("Content-MD5")) {
                    request.addHeader("Content-MD5", Md5Utils.md5AsBase64((byte[])stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8)));
                }
                request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
                request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            }
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

