/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.time.Instant;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshallers;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;

public class GetObjectRequestMarshaller
implements Marshaller<Request<GetObjectRequest>, GetObjectRequest> {
    public Request<GetObjectRequest> marshall(GetObjectRequest getObjectRequest) {
        if (getObjectRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getObjectRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.GET);
        if (getObjectRequest.ifMatch() != null) {
            request.addHeader("If-Match", StringUtils.fromString((String)getObjectRequest.ifMatch()));
        }
        if (getObjectRequest.ifModifiedSince() != null) {
            request.addHeader("If-Modified-Since", StringUtils.fromInstant((Instant)getObjectRequest.ifModifiedSince()));
        }
        if (getObjectRequest.ifNoneMatch() != null) {
            request.addHeader("If-None-Match", StringUtils.fromString((String)getObjectRequest.ifNoneMatch()));
        }
        if (getObjectRequest.ifUnmodifiedSince() != null) {
            request.addHeader("If-Unmodified-Since", StringUtils.fromInstant((Instant)getObjectRequest.ifUnmodifiedSince()));
        }
        if (getObjectRequest.range() != null) {
            request.addHeader("Range", StringUtils.fromString((String)getObjectRequest.range()));
        }
        if (getObjectRequest.sseCustomerAlgorithm() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-algorithm", StringUtils.fromString((String)getObjectRequest.sseCustomerAlgorithm()));
        }
        if (getObjectRequest.sseCustomerKey() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-key", StringUtils.fromString((String)getObjectRequest.sseCustomerKey()));
        }
        if (getObjectRequest.sseCustomerKeyMD5() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-key-MD5", StringUtils.fromString((String)getObjectRequest.sseCustomerKeyMD5()));
        }
        if (getObjectRequest.requestPayerString() != null) {
            request.addHeader("x-amz-request-payer", StringUtils.fromString((String)getObjectRequest.requestPayerString()));
        }
        String uriResourcePath = "/{Bucket}/{Key+}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", getObjectRequest.bucket());
        uriResourcePath = PathMarshallers.GREEDY.marshall(uriResourcePath, "Key", getObjectRequest.key());
        request.setResourcePath(uriResourcePath);
        if (getObjectRequest.responseCacheControl() != null) {
            request.addParameter("response-cache-control", StringUtils.fromString((String)getObjectRequest.responseCacheControl()));
        }
        if (getObjectRequest.responseContentDisposition() != null) {
            request.addParameter("response-content-disposition", StringUtils.fromString((String)getObjectRequest.responseContentDisposition()));
        }
        if (getObjectRequest.responseContentEncoding() != null) {
            request.addParameter("response-content-encoding", StringUtils.fromString((String)getObjectRequest.responseContentEncoding()));
        }
        if (getObjectRequest.responseContentLanguage() != null) {
            request.addParameter("response-content-language", StringUtils.fromString((String)getObjectRequest.responseContentLanguage()));
        }
        if (getObjectRequest.responseContentType() != null) {
            request.addParameter("response-content-type", StringUtils.fromString((String)getObjectRequest.responseContentType()));
        }
        if (getObjectRequest.responseExpires() != null) {
            request.addParameter("response-expires", StringUtils.fromInstant((Instant)getObjectRequest.responseExpires()));
        }
        if (getObjectRequest.versionId() != null) {
            request.addParameter("versionId", StringUtils.fromString((String)getObjectRequest.versionId()));
        }
        if (getObjectRequest.partNumber() != null) {
            request.addParameter("partNumber", StringUtils.fromInteger((Integer)getObjectRequest.partNumber()));
        }
        return request;
    }
}

