/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshallers;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.core.util.UriResourcePathUtils;
import software.amazon.awssdk.services.s3.model.DeleteBucketInventoryConfigurationRequest;

public class DeleteBucketInventoryConfigurationRequestMarshaller
implements Marshaller<Request<DeleteBucketInventoryConfigurationRequest>, DeleteBucketInventoryConfigurationRequest> {
    public Request<DeleteBucketInventoryConfigurationRequest> marshall(DeleteBucketInventoryConfigurationRequest deleteBucketInventoryConfigurationRequest) {
        if (deleteBucketInventoryConfigurationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteBucketInventoryConfigurationRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/{Bucket}?inventory";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParametersToRequest((Request)request, (String)uriResourcePath);
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", deleteBucketInventoryConfigurationRequest.bucket());
        request.setResourcePath(uriResourcePath);
        if (deleteBucketInventoryConfigurationRequest.id() != null) {
            request.addParameter("id", StringUtils.fromString((String)deleteBucketInventoryConfigurationRequest.id()));
        }
        return request;
    }
}

