/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.CommonPrefix;
import software.amazon.awssdk.services.s3.model.ListMultipartUploadsRequest;
import software.amazon.awssdk.services.s3.model.ListMultipartUploadsResponse;
import software.amazon.awssdk.services.s3.model.MultipartUpload;

public final class ListMultipartUploadsPaginator
implements SdkIterable<ListMultipartUploadsResponse> {
    private final S3Client client;
    private final ListMultipartUploadsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListMultipartUploadsPaginator(S3Client client, ListMultipartUploadsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListMultipartUploadsResponseFetcher();
    }

    public Iterator<ListMultipartUploadsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<MultipartUpload> uploads() {
        Function<ListMultipartUploadsResponse, Iterator> getIterator = response -> response != null ? response.uploads().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public SdkIterable<CommonPrefix> commonPrefixes() {
        Function<ListMultipartUploadsResponse, Iterator> getIterator = response -> response != null ? response.commonPrefixes().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListMultipartUploadsResponseFetcher
    implements NextPageFetcher<ListMultipartUploadsResponse> {
        private ListMultipartUploadsResponseFetcher() {
        }

        public boolean hasNextPage(ListMultipartUploadsResponse previousPage) {
            return previousPage.isTruncated();
        }

        public ListMultipartUploadsResponse nextPage(ListMultipartUploadsResponse previousPage) {
            if (previousPage == null) {
                return ListMultipartUploadsPaginator.this.client.listMultipartUploads(ListMultipartUploadsPaginator.this.firstRequest);
            }
            return ListMultipartUploadsPaginator.this.client.listMultipartUploads((ListMultipartUploadsRequest)((Object)ListMultipartUploadsPaginator.this.firstRequest.toBuilder().keyMarker(previousPage.nextKeyMarker()).uploadIdMarker(previousPage.nextUploadIdMarker()).build()));
        }
    }
}

