/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.s3.model.MetricsConfiguration;
import software.amazon.awssdk.services.s3.model.MetricsConfigurationListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListBucketMetricsConfigurationsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListBucketMetricsConfigurationsResponse> {
    private final Boolean isTruncated;
    private final String continuationToken;
    private final String nextContinuationToken;
    private final List<MetricsConfiguration> metricsConfigurationList;

    private ListBucketMetricsConfigurationsResponse(BuilderImpl builder) {
        this.isTruncated = builder.isTruncated;
        this.continuationToken = builder.continuationToken;
        this.nextContinuationToken = builder.nextContinuationToken;
        this.metricsConfigurationList = builder.metricsConfigurationList;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public String continuationToken() {
        return this.continuationToken;
    }

    public String nextContinuationToken() {
        return this.nextContinuationToken;
    }

    public List<MetricsConfiguration> metricsConfigurationList() {
        return this.metricsConfigurationList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(this.continuationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextContinuationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricsConfigurationList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBucketMetricsConfigurationsResponse)) {
            return false;
        }
        ListBucketMetricsConfigurationsResponse other = (ListBucketMetricsConfigurationsResponse)((Object)obj);
        return Objects.equals(this.isTruncated(), other.isTruncated()) && Objects.equals(this.continuationToken(), other.continuationToken()) && Objects.equals(this.nextContinuationToken(), other.nextContinuationToken()) && Objects.equals(this.metricsConfigurationList(), other.metricsConfigurationList());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.isTruncated() != null) {
            sb.append("IsTruncated: ").append(this.isTruncated()).append(",");
        }
        if (this.continuationToken() != null) {
            sb.append("ContinuationToken: ").append(this.continuationToken()).append(",");
        }
        if (this.nextContinuationToken() != null) {
            sb.append("NextContinuationToken: ").append(this.nextContinuationToken()).append(",");
        }
        if (this.metricsConfigurationList() != null) {
            sb.append("MetricsConfigurationList: ").append(this.metricsConfigurationList()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IsTruncated": {
                return Optional.of(clazz.cast(this.isTruncated()));
            }
            case "ContinuationToken": {
                return Optional.of(clazz.cast(this.continuationToken()));
            }
            case "NextContinuationToken": {
                return Optional.of(clazz.cast(this.nextContinuationToken()));
            }
            case "MetricsConfigurationList": {
                return Optional.of(clazz.cast(this.metricsConfigurationList()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean isTruncated;
        private String continuationToken;
        private String nextContinuationToken;
        private List<MetricsConfiguration> metricsConfigurationList;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBucketMetricsConfigurationsResponse model) {
            this.isTruncated(model.isTruncated);
            this.continuationToken(model.continuationToken);
            this.nextContinuationToken(model.nextContinuationToken);
            this.metricsConfigurationList(model.metricsConfigurationList);
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getContinuationToken() {
            return this.continuationToken;
        }

        @Override
        public final Builder continuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
            return this;
        }

        public final void setContinuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
        }

        public final String getNextContinuationToken() {
            return this.nextContinuationToken;
        }

        @Override
        public final Builder nextContinuationToken(String nextContinuationToken) {
            this.nextContinuationToken = nextContinuationToken;
            return this;
        }

        public final void setNextContinuationToken(String nextContinuationToken) {
            this.nextContinuationToken = nextContinuationToken;
        }

        public final Collection<MetricsConfiguration.Builder> getMetricsConfigurationList() {
            return this.metricsConfigurationList != null ? (Collection)this.metricsConfigurationList.stream().map(MetricsConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder metricsConfigurationList(Collection<MetricsConfiguration> metricsConfigurationList) {
            this.metricsConfigurationList = MetricsConfigurationListCopier.copy(metricsConfigurationList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricsConfigurationList(MetricsConfiguration ... metricsConfigurationList) {
            this.metricsConfigurationList(Arrays.asList(metricsConfigurationList));
            return this;
        }

        public final void setMetricsConfigurationList(Collection<MetricsConfiguration.BuilderImpl> metricsConfigurationList) {
            this.metricsConfigurationList = MetricsConfigurationListCopier.copyFromBuilder(metricsConfigurationList);
        }

        public ListBucketMetricsConfigurationsResponse build() {
            return new ListBucketMetricsConfigurationsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListBucketMetricsConfigurationsResponse> {
        public Builder isTruncated(Boolean var1);

        public Builder continuationToken(String var1);

        public Builder nextContinuationToken(String var1);

        public Builder metricsConfigurationList(Collection<MetricsConfiguration> var1);

        public Builder metricsConfigurationList(MetricsConfiguration ... var1);
    }
}

