/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.s3.model.Grant;
import software.amazon.awssdk.services.s3.model.GrantsCopier;
import software.amazon.awssdk.services.s3.model.Owner;
import software.amazon.awssdk.services.s3.model.RequestCharged;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetObjectAclResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetObjectAclResponse> {
    private final Owner owner;
    private final List<Grant> grants;
    private final String requestCharged;

    private GetObjectAclResponse(BuilderImpl builder) {
        this.owner = builder.owner;
        this.grants = builder.grants;
        this.requestCharged = builder.requestCharged;
    }

    public Owner owner() {
        return this.owner;
    }

    public List<Grant> grants() {
        return this.grants;
    }

    public RequestCharged requestCharged() {
        return RequestCharged.fromValue(this.requestCharged);
    }

    public String requestChargedString() {
        return this.requestCharged;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.grants());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestChargedString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetObjectAclResponse)) {
            return false;
        }
        GetObjectAclResponse other = (GetObjectAclResponse)((Object)obj);
        return Objects.equals(this.owner(), other.owner()) && Objects.equals(this.grants(), other.grants()) && Objects.equals(this.requestChargedString(), other.requestChargedString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.owner() != null) {
            sb.append("Owner: ").append(this.owner()).append(",");
        }
        if (this.grants() != null) {
            sb.append("Grants: ").append(this.grants()).append(",");
        }
        if (this.requestChargedString() != null) {
            sb.append("RequestCharged: ").append(this.requestChargedString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Owner": {
                return Optional.of(clazz.cast(this.owner()));
            }
            case "Grants": {
                return Optional.of(clazz.cast(this.grants()));
            }
            case "RequestCharged": {
                return Optional.of(clazz.cast(this.requestChargedString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Owner owner;
        private List<Grant> grants;
        private String requestCharged;

        private BuilderImpl() {
        }

        private BuilderImpl(GetObjectAclResponse model) {
            this.owner(model.owner);
            this.grants(model.grants);
            this.requestCharged(model.requestCharged);
        }

        public final Owner.Builder getOwner() {
            return this.owner != null ? this.owner.toBuilder() : null;
        }

        @Override
        public final Builder owner(Owner owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(Owner.BuilderImpl owner) {
            this.owner = owner != null ? owner.build() : null;
        }

        public final Collection<Grant.Builder> getGrants() {
            return this.grants != null ? (Collection)this.grants.stream().map(Grant::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder grants(Collection<Grant> grants) {
            this.grants = GrantsCopier.copy(grants);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grants(Grant ... grants) {
            this.grants(Arrays.asList(grants));
            return this;
        }

        public final void setGrants(Collection<Grant.BuilderImpl> grants) {
            this.grants = GrantsCopier.copyFromBuilder(grants);
        }

        public final String getRequestCharged() {
            return this.requestCharged;
        }

        @Override
        public final Builder requestCharged(String requestCharged) {
            this.requestCharged = requestCharged;
            return this;
        }

        @Override
        public final Builder requestCharged(RequestCharged requestCharged) {
            this.requestCharged(requestCharged.toString());
            return this;
        }

        public final void setRequestCharged(String requestCharged) {
            this.requestCharged = requestCharged;
        }

        public GetObjectAclResponse build() {
            return new GetObjectAclResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetObjectAclResponse> {
        public Builder owner(Owner var1);

        default public Builder owner(Consumer<Owner.Builder> owner) {
            return this.owner((Owner)((Owner.Builder)Owner.builder().apply(owner)).build());
        }

        public Builder grants(Collection<Grant> var1);

        public Builder grants(Grant ... var1);

        public Builder requestCharged(String var1);

        public Builder requestCharged(RequestCharged var1);
    }
}

