/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.s3.model.ObjectIdentifier;
import software.amazon.awssdk.services.s3.model.ObjectIdentifierListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Delete
implements ToCopyableBuilder<Builder, Delete> {
    private final List<ObjectIdentifier> objects;
    private final Boolean quiet;

    private Delete(BuilderImpl builder) {
        this.objects = builder.objects;
        this.quiet = builder.quiet;
    }

    public List<ObjectIdentifier> objects() {
        return this.objects;
    }

    public Boolean quiet() {
        return this.quiet;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.objects());
        hashCode = 31 * hashCode + Objects.hashCode(this.quiet());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Delete)) {
            return false;
        }
        Delete other = (Delete)obj;
        return Objects.equals(this.objects(), other.objects()) && Objects.equals(this.quiet(), other.quiet());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.objects() != null) {
            sb.append("Objects: ").append(this.objects()).append(",");
        }
        if (this.quiet() != null) {
            sb.append("Quiet: ").append(this.quiet()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Objects": {
                return Optional.of(clazz.cast(this.objects()));
            }
            case "Quiet": {
                return Optional.of(clazz.cast(this.quiet()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<ObjectIdentifier> objects;
        private Boolean quiet;

        private BuilderImpl() {
        }

        private BuilderImpl(Delete model) {
            this.objects(model.objects);
            this.quiet(model.quiet);
        }

        public final Collection<ObjectIdentifier.Builder> getObjects() {
            return this.objects != null ? (Collection)this.objects.stream().map(ObjectIdentifier::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder objects(Collection<ObjectIdentifier> objects) {
            this.objects = ObjectIdentifierListCopier.copy(objects);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objects(ObjectIdentifier ... objects) {
            this.objects(Arrays.asList(objects));
            return this;
        }

        public final void setObjects(Collection<ObjectIdentifier.BuilderImpl> objects) {
            this.objects = ObjectIdentifierListCopier.copyFromBuilder(objects);
        }

        public final Boolean getQuiet() {
            return this.quiet;
        }

        @Override
        public final Builder quiet(Boolean quiet) {
            this.quiet = quiet;
            return this;
        }

        public final void setQuiet(Boolean quiet) {
            this.quiet = quiet;
        }

        public Delete build() {
            return new Delete(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Delete> {
        public Builder objects(Collection<ObjectIdentifier> var1);

        public Builder objects(ObjectIdentifier ... var1);

        public Builder quiet(Boolean var1);
    }
}

