/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.s3.model.AnalyticsS3ExportFileFormat;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AnalyticsS3BucketDestination
implements ToCopyableBuilder<Builder, AnalyticsS3BucketDestination> {
    private final String format;
    private final String bucketAccountId;
    private final String bucket;
    private final String prefix;

    private AnalyticsS3BucketDestination(BuilderImpl builder) {
        this.format = builder.format;
        this.bucketAccountId = builder.bucketAccountId;
        this.bucket = builder.bucket;
        this.prefix = builder.prefix;
    }

    public AnalyticsS3ExportFileFormat format() {
        return AnalyticsS3ExportFileFormat.fromValue(this.format);
    }

    public String formatString() {
        return this.format;
    }

    public String bucketAccountId() {
        return this.bucketAccountId;
    }

    public String bucket() {
        return this.bucket;
    }

    public String prefix() {
        return this.prefix;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.formatString());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefix());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalyticsS3BucketDestination)) {
            return false;
        }
        AnalyticsS3BucketDestination other = (AnalyticsS3BucketDestination)obj;
        return Objects.equals(this.formatString(), other.formatString()) && Objects.equals(this.bucketAccountId(), other.bucketAccountId()) && Objects.equals(this.bucket(), other.bucket()) && Objects.equals(this.prefix(), other.prefix());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.formatString() != null) {
            sb.append("Format: ").append(this.formatString()).append(",");
        }
        if (this.bucketAccountId() != null) {
            sb.append("BucketAccountId: ").append(this.bucketAccountId()).append(",");
        }
        if (this.bucket() != null) {
            sb.append("Bucket: ").append(this.bucket()).append(",");
        }
        if (this.prefix() != null) {
            sb.append("Prefix: ").append(this.prefix()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Format": {
                return Optional.of(clazz.cast(this.formatString()));
            }
            case "BucketAccountId": {
                return Optional.of(clazz.cast(this.bucketAccountId()));
            }
            case "Bucket": {
                return Optional.of(clazz.cast(this.bucket()));
            }
            case "Prefix": {
                return Optional.of(clazz.cast(this.prefix()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String format;
        private String bucketAccountId;
        private String bucket;
        private String prefix;

        private BuilderImpl() {
        }

        private BuilderImpl(AnalyticsS3BucketDestination model) {
            this.format(model.format);
            this.bucketAccountId(model.bucketAccountId);
            this.bucket(model.bucket);
            this.prefix(model.prefix);
        }

        public final String getFormat() {
            return this.format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(AnalyticsS3ExportFileFormat format) {
            this.format(format.toString());
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final String getBucketAccountId() {
            return this.bucketAccountId;
        }

        @Override
        public final Builder bucketAccountId(String bucketAccountId) {
            this.bucketAccountId = bucketAccountId;
            return this;
        }

        public final void setBucketAccountId(String bucketAccountId) {
            this.bucketAccountId = bucketAccountId;
        }

        public final String getBucket() {
            return this.bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getPrefix() {
            return this.prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public AnalyticsS3BucketDestination build() {
            return new AnalyticsS3BucketDestination(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AnalyticsS3BucketDestination> {
        public Builder format(String var1);

        public Builder format(AnalyticsS3ExportFileFormat var1);

        public Builder bucketAccountId(String var1);

        public Builder bucket(String var1);

        public Builder prefix(String var1);
    }
}

