/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.FilterRule;
import software.amazon.awssdk.services.s3.model.S3KeyFilter;
import software.amazon.awssdk.services.s3.transform.FilterRuleUnmarshaller;

public class S3KeyFilterUnmarshaller
implements Unmarshaller<S3KeyFilter, StaxUnmarshallerContext> {
    private static final S3KeyFilterUnmarshaller INSTANCE = new S3KeyFilterUnmarshaller();

    public S3KeyFilter unmarshall(StaxUnmarshallerContext context) throws Exception {
        S3KeyFilter.Builder s3KeyFilter;
        block5: {
            s3KeyFilter = S3KeyFilter.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<FilterRule> filterRules = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    s3KeyFilter.filterRules(filterRules);
                    break block5;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (!context.testExpression("FilterRule", targetDepth)) continue;
                    if (filterRules == null) {
                        filterRules = new ArrayList<FilterRule>();
                    }
                    filterRules.add(FilterRuleUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            s3KeyFilter.filterRules(filterRules);
        }
        return (S3KeyFilter)s3KeyFilter.build();
    }

    public static S3KeyFilterUnmarshaller getInstance() {
        return INSTANCE;
    }
}

