/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshallers;
import software.amazon.awssdk.core.util.Md5Utils;
import software.amazon.awssdk.core.util.StringInputStream;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.core.util.UriResourcePathUtils;
import software.amazon.awssdk.core.util.XmlWriter;
import software.amazon.awssdk.services.s3.model.InventoryConfiguration;
import software.amazon.awssdk.services.s3.model.InventoryDestination;
import software.amazon.awssdk.services.s3.model.InventoryFilter;
import software.amazon.awssdk.services.s3.model.InventoryS3BucketDestination;
import software.amazon.awssdk.services.s3.model.InventorySchedule;
import software.amazon.awssdk.services.s3.model.PutBucketInventoryConfigurationRequest;

public class PutBucketInventoryConfigurationRequestMarshaller
implements Marshaller<Request<PutBucketInventoryConfigurationRequest>, PutBucketInventoryConfigurationRequest> {
    public Request<PutBucketInventoryConfigurationRequest> marshall(PutBucketInventoryConfigurationRequest putBucketInventoryConfigurationRequest) {
        if (putBucketInventoryConfigurationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putBucketInventoryConfigurationRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.PUT);
        String uriResourcePath = "/{Bucket}?inventory";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParametersToRequest((Request)request, (String)uriResourcePath);
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", putBucketInventoryConfigurationRequest.bucket());
        request.setResourcePath(uriResourcePath);
        if (putBucketInventoryConfigurationRequest.id() != null) {
            request.addParameter("id", StringUtils.fromString((String)putBucketInventoryConfigurationRequest.id()));
        }
        try {
            StringWriter stringWriter = null;
            InventoryConfiguration inventoryConfiguration = putBucketInventoryConfigurationRequest.inventoryConfiguration();
            if (inventoryConfiguration != null) {
                InventorySchedule schedule;
                List<String> inventoryConfigurationOptionalFieldsList;
                InventoryFilter filter;
                stringWriter = new StringWriter();
                XmlWriter xmlWriter = new XmlWriter((Writer)stringWriter, "http://s3.amazonaws.com/doc/2006-03-01/");
                xmlWriter.startElement("InventoryConfiguration");
                InventoryDestination destination = inventoryConfiguration.destination();
                if (destination != null) {
                    xmlWriter.startElement("Destination");
                    InventoryS3BucketDestination s3BucketDestination = destination.s3BucketDestination();
                    if (s3BucketDestination != null) {
                        xmlWriter.startElement("S3BucketDestination");
                        if (s3BucketDestination.accountId() != null) {
                            xmlWriter.startElement("AccountId").value(s3BucketDestination.accountId()).endElement();
                        }
                        if (s3BucketDestination.bucket() != null) {
                            xmlWriter.startElement("Bucket").value(s3BucketDestination.bucket()).endElement();
                        }
                        if (s3BucketDestination.formatString() != null) {
                            xmlWriter.startElement("Format").value(s3BucketDestination.formatString()).endElement();
                        }
                        if (s3BucketDestination.prefix() != null) {
                            xmlWriter.startElement("Prefix").value(s3BucketDestination.prefix()).endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                if (inventoryConfiguration.isEnabled() != null) {
                    xmlWriter.startElement("IsEnabled").value((Object)inventoryConfiguration.isEnabled()).endElement();
                }
                if ((filter = inventoryConfiguration.filter()) != null) {
                    xmlWriter.startElement("Filter");
                    if (filter.prefix() != null) {
                        xmlWriter.startElement("Prefix").value(filter.prefix()).endElement();
                    }
                    xmlWriter.endElement();
                }
                if (inventoryConfiguration.id() != null) {
                    xmlWriter.startElement("Id").value(inventoryConfiguration.id()).endElement();
                }
                if (inventoryConfiguration.includedObjectVersionsString() != null) {
                    xmlWriter.startElement("IncludedObjectVersions").value(inventoryConfiguration.includedObjectVersionsString()).endElement();
                }
                if ((inventoryConfigurationOptionalFieldsList = inventoryConfiguration.optionalFieldsStrings()) != null) {
                    xmlWriter.startElement("OptionalFields");
                    for (String inventoryConfigurationOptionalFieldsListValue : inventoryConfigurationOptionalFieldsList) {
                        xmlWriter.startElement("Field");
                        xmlWriter.value(inventoryConfigurationOptionalFieldsListValue);
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                if ((schedule = inventoryConfiguration.schedule()) != null) {
                    xmlWriter.startElement("Schedule");
                    if (schedule.frequencyString() != null) {
                        xmlWriter.startElement("Frequency").value(schedule.frequencyString()).endElement();
                    }
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }
            if (stringWriter != null) {
                if (!request.getHeaders().containsKey("Content-MD5")) {
                    request.addHeader("Content-MD5", Md5Utils.md5AsBase64((byte[])stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8)));
                }
                request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
                request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            }
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

