/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshallers;
import software.amazon.awssdk.core.util.Md5Utils;
import software.amazon.awssdk.core.util.StringInputStream;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.core.util.UriResourcePathUtils;
import software.amazon.awssdk.core.util.XmlWriter;
import software.amazon.awssdk.services.s3.model.AnalyticsAndOperator;
import software.amazon.awssdk.services.s3.model.AnalyticsConfiguration;
import software.amazon.awssdk.services.s3.model.AnalyticsExportDestination;
import software.amazon.awssdk.services.s3.model.AnalyticsFilter;
import software.amazon.awssdk.services.s3.model.AnalyticsS3BucketDestination;
import software.amazon.awssdk.services.s3.model.PutBucketAnalyticsConfigurationRequest;
import software.amazon.awssdk.services.s3.model.StorageClassAnalysis;
import software.amazon.awssdk.services.s3.model.StorageClassAnalysisDataExport;
import software.amazon.awssdk.services.s3.model.Tag;

public class PutBucketAnalyticsConfigurationRequestMarshaller
implements Marshaller<Request<PutBucketAnalyticsConfigurationRequest>, PutBucketAnalyticsConfigurationRequest> {
    public Request<PutBucketAnalyticsConfigurationRequest> marshall(PutBucketAnalyticsConfigurationRequest putBucketAnalyticsConfigurationRequest) {
        if (putBucketAnalyticsConfigurationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putBucketAnalyticsConfigurationRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.PUT);
        String uriResourcePath = "/{Bucket}?analytics";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParametersToRequest((Request)request, (String)uriResourcePath);
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", putBucketAnalyticsConfigurationRequest.bucket());
        request.setResourcePath(uriResourcePath);
        if (putBucketAnalyticsConfigurationRequest.id() != null) {
            request.addParameter("id", StringUtils.fromString((String)putBucketAnalyticsConfigurationRequest.id()));
        }
        try {
            StringWriter stringWriter = null;
            AnalyticsConfiguration analyticsConfiguration = putBucketAnalyticsConfigurationRequest.analyticsConfiguration();
            if (analyticsConfiguration != null) {
                StorageClassAnalysis storageClassAnalysis;
                AnalyticsFilter filter;
                stringWriter = new StringWriter();
                XmlWriter xmlWriter = new XmlWriter((Writer)stringWriter, "http://s3.amazonaws.com/doc/2006-03-01/");
                xmlWriter.startElement("AnalyticsConfiguration");
                if (analyticsConfiguration.id() != null) {
                    xmlWriter.startElement("Id").value(analyticsConfiguration.id()).endElement();
                }
                if ((filter = analyticsConfiguration.filter()) != null) {
                    AnalyticsAndOperator and;
                    Tag tag;
                    xmlWriter.startElement("Filter");
                    if (filter.prefix() != null) {
                        xmlWriter.startElement("Prefix").value(filter.prefix()).endElement();
                    }
                    if ((tag = filter.tag()) != null) {
                        xmlWriter.startElement("Tag");
                        if (tag.key() != null) {
                            xmlWriter.startElement("Key").value(tag.key()).endElement();
                        }
                        if (tag.value() != null) {
                            xmlWriter.startElement("Value").value(tag.value()).endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if ((and = filter.and()) != null) {
                        List<Tag> analyticsAndOperatorTagsList;
                        xmlWriter.startElement("And");
                        if (and.prefix() != null) {
                            xmlWriter.startElement("Prefix").value(and.prefix()).endElement();
                        }
                        if ((analyticsAndOperatorTagsList = and.tags()) != null) {
                            for (Tag analyticsAndOperatorTagsListValue : analyticsAndOperatorTagsList) {
                                xmlWriter.startElement("Tag");
                                if (analyticsAndOperatorTagsListValue.key() != null) {
                                    xmlWriter.startElement("Key").value(analyticsAndOperatorTagsListValue.key()).endElement();
                                }
                                if (analyticsAndOperatorTagsListValue.value() != null) {
                                    xmlWriter.startElement("Value").value(analyticsAndOperatorTagsListValue.value()).endElement();
                                }
                                xmlWriter.endElement();
                            }
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                if ((storageClassAnalysis = analyticsConfiguration.storageClassAnalysis()) != null) {
                    xmlWriter.startElement("StorageClassAnalysis");
                    StorageClassAnalysisDataExport dataExport = storageClassAnalysis.dataExport();
                    if (dataExport != null) {
                        AnalyticsExportDestination destination;
                        xmlWriter.startElement("DataExport");
                        if (dataExport.outputSchemaVersionString() != null) {
                            xmlWriter.startElement("OutputSchemaVersion").value(dataExport.outputSchemaVersionString()).endElement();
                        }
                        if ((destination = dataExport.destination()) != null) {
                            xmlWriter.startElement("Destination");
                            AnalyticsS3BucketDestination s3BucketDestination = destination.s3BucketDestination();
                            if (s3BucketDestination != null) {
                                xmlWriter.startElement("S3BucketDestination");
                                if (s3BucketDestination.formatString() != null) {
                                    xmlWriter.startElement("Format").value(s3BucketDestination.formatString()).endElement();
                                }
                                if (s3BucketDestination.bucketAccountId() != null) {
                                    xmlWriter.startElement("BucketAccountId").value(s3BucketDestination.bucketAccountId()).endElement();
                                }
                                if (s3BucketDestination.bucket() != null) {
                                    xmlWriter.startElement("Bucket").value(s3BucketDestination.bucket()).endElement();
                                }
                                if (s3BucketDestination.prefix() != null) {
                                    xmlWriter.startElement("Prefix").value(s3BucketDestination.prefix()).endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }
            if (stringWriter != null) {
                if (!request.getHeaders().containsKey("Content-MD5")) {
                    request.addHeader("Content-MD5", Md5Utils.md5AsBase64((byte[])stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8)));
                }
                request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
                request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            }
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

