/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshallers;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.core.util.UriResourcePathUtils;
import software.amazon.awssdk.services.s3.model.GetObjectTaggingRequest;

public class GetObjectTaggingRequestMarshaller
implements Marshaller<Request<GetObjectTaggingRequest>, GetObjectTaggingRequest> {
    public Request<GetObjectTaggingRequest> marshall(GetObjectTaggingRequest getObjectTaggingRequest) {
        if (getObjectTaggingRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getObjectTaggingRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/{Bucket}/{Key+}?tagging";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParametersToRequest((Request)request, (String)uriResourcePath);
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", getObjectTaggingRequest.bucket());
        uriResourcePath = PathMarshallers.GREEDY.marshall(uriResourcePath, "Key", getObjectTaggingRequest.key());
        request.setResourcePath(uriResourcePath);
        if (getObjectTaggingRequest.versionId() != null) {
            request.addParameter("versionId", StringUtils.fromString((String)getObjectTaggingRequest.versionId()));
        }
        return request;
    }
}

