/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshallers;
import software.amazon.awssdk.core.util.Md5Utils;
import software.amazon.awssdk.core.util.StringInputStream;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.core.util.UriResourcePathUtils;
import software.amazon.awssdk.core.util.XmlWriter;
import software.amazon.awssdk.services.s3.model.Delete;
import software.amazon.awssdk.services.s3.model.DeleteObjectsRequest;
import software.amazon.awssdk.services.s3.model.ObjectIdentifier;

public class DeleteObjectsRequestMarshaller
implements Marshaller<Request<DeleteObjectsRequest>, DeleteObjectsRequest> {
    public Request<DeleteObjectsRequest> marshall(DeleteObjectsRequest deleteObjectsRequest) {
        if (deleteObjectsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteObjectsRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteObjectsRequest.mfa() != null) {
            request.addHeader("x-amz-mfa", StringUtils.fromString((String)deleteObjectsRequest.mfa()));
        }
        if (deleteObjectsRequest.requestPayerString() != null) {
            request.addHeader("x-amz-request-payer", StringUtils.fromString((String)deleteObjectsRequest.requestPayerString()));
        }
        String uriResourcePath = "/{Bucket}?delete";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParametersToRequest((Request)request, (String)uriResourcePath);
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", deleteObjectsRequest.bucket());
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = null;
            Delete delete = deleteObjectsRequest.delete();
            if (delete != null) {
                stringWriter = new StringWriter();
                XmlWriter xmlWriter = new XmlWriter((Writer)stringWriter, "http://s3.amazonaws.com/doc/2006-03-01/");
                xmlWriter.startElement("Delete");
                List<ObjectIdentifier> deleteObjectsList = delete.objects();
                if (deleteObjectsList != null) {
                    for (ObjectIdentifier deleteObjectsListValue : deleteObjectsList) {
                        xmlWriter.startElement("Object");
                        if (deleteObjectsListValue.key() != null) {
                            xmlWriter.startElement("Key").value(deleteObjectsListValue.key()).endElement();
                        }
                        if (deleteObjectsListValue.versionId() != null) {
                            xmlWriter.startElement("VersionId").value(deleteObjectsListValue.versionId()).endElement();
                        }
                        xmlWriter.endElement();
                    }
                }
                if (delete.quiet() != null) {
                    xmlWriter.startElement("Quiet").value((Object)delete.quiet()).endElement();
                }
                xmlWriter.endElement();
            }
            if (stringWriter != null) {
                if (!request.getHeaders().containsKey("Content-MD5")) {
                    request.addHeader("Content-MD5", Md5Utils.md5AsBase64((byte[])stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8)));
                }
                request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
                request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            }
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

