/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.s3.model.BucketLifecycleConfiguration;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutBucketLifecycleConfigurationRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, PutBucketLifecycleConfigurationRequest> {
    private final String bucket;
    private final BucketLifecycleConfiguration lifecycleConfiguration;

    private PutBucketLifecycleConfigurationRequest(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.lifecycleConfiguration = builder.lifecycleConfiguration;
    }

    public String bucket() {
        return this.bucket;
    }

    public BucketLifecycleConfiguration lifecycleConfiguration() {
        return this.lifecycleConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.bucket() == null ? 0 : this.bucket().hashCode());
        hashCode = 31 * hashCode + (this.lifecycleConfiguration() == null ? 0 : this.lifecycleConfiguration().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutBucketLifecycleConfigurationRequest)) {
            return false;
        }
        PutBucketLifecycleConfigurationRequest other = (PutBucketLifecycleConfigurationRequest)((Object)obj);
        if (other.bucket() == null ^ this.bucket() == null) {
            return false;
        }
        if (other.bucket() != null && !other.bucket().equals(this.bucket())) {
            return false;
        }
        if (other.lifecycleConfiguration() == null ^ this.lifecycleConfiguration() == null) {
            return false;
        }
        return other.lifecycleConfiguration() == null || other.lifecycleConfiguration().equals(this.lifecycleConfiguration());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.bucket() != null) {
            sb.append("Bucket: ").append(this.bucket()).append(",");
        }
        if (this.lifecycleConfiguration() != null) {
            sb.append("LifecycleConfiguration: ").append(this.lifecycleConfiguration()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Bucket": {
                return Optional.of(clazz.cast(this.bucket()));
            }
            case "LifecycleConfiguration": {
                return Optional.of(clazz.cast(this.lifecycleConfiguration()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String bucket;
        private BucketLifecycleConfiguration lifecycleConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PutBucketLifecycleConfigurationRequest model) {
            this.bucket(model.bucket);
            this.lifecycleConfiguration(model.lifecycleConfiguration);
        }

        public final String getBucket() {
            return this.bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final BucketLifecycleConfiguration.Builder getLifecycleConfiguration() {
            return this.lifecycleConfiguration != null ? this.lifecycleConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder lifecycleConfiguration(BucketLifecycleConfiguration lifecycleConfiguration) {
            this.lifecycleConfiguration = lifecycleConfiguration;
            return this;
        }

        public final void setLifecycleConfiguration(BucketLifecycleConfiguration.BuilderImpl lifecycleConfiguration) {
            this.lifecycleConfiguration = lifecycleConfiguration != null ? lifecycleConfiguration.build() : null;
        }

        public PutBucketLifecycleConfigurationRequest build() {
            return new PutBucketLifecycleConfigurationRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PutBucketLifecycleConfigurationRequest> {
        public Builder bucket(String var1);

        public Builder lifecycleConfiguration(BucketLifecycleConfiguration var1);
    }
}

