/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.s3.model.LambdaFunctionConfiguration;
import software.amazon.awssdk.services.s3.model.LambdaFunctionConfigurationListCopier;
import software.amazon.awssdk.services.s3.model.QueueConfiguration;
import software.amazon.awssdk.services.s3.model.QueueConfigurationListCopier;
import software.amazon.awssdk.services.s3.model.TopicConfiguration;
import software.amazon.awssdk.services.s3.model.TopicConfigurationListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class NotificationConfiguration
implements ToCopyableBuilder<Builder, NotificationConfiguration> {
    private final List<TopicConfiguration> topicConfigurations;
    private final List<QueueConfiguration> queueConfigurations;
    private final List<LambdaFunctionConfiguration> lambdaFunctionConfigurations;

    private NotificationConfiguration(BuilderImpl builder) {
        this.topicConfigurations = builder.topicConfigurations;
        this.queueConfigurations = builder.queueConfigurations;
        this.lambdaFunctionConfigurations = builder.lambdaFunctionConfigurations;
    }

    public List<TopicConfiguration> topicConfigurations() {
        return this.topicConfigurations;
    }

    public List<QueueConfiguration> queueConfigurations() {
        return this.queueConfigurations;
    }

    public List<LambdaFunctionConfiguration> lambdaFunctionConfigurations() {
        return this.lambdaFunctionConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.topicConfigurations() == null ? 0 : this.topicConfigurations().hashCode());
        hashCode = 31 * hashCode + (this.queueConfigurations() == null ? 0 : this.queueConfigurations().hashCode());
        hashCode = 31 * hashCode + (this.lambdaFunctionConfigurations() == null ? 0 : this.lambdaFunctionConfigurations().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotificationConfiguration)) {
            return false;
        }
        NotificationConfiguration other = (NotificationConfiguration)obj;
        if (other.topicConfigurations() == null ^ this.topicConfigurations() == null) {
            return false;
        }
        if (other.topicConfigurations() != null && !other.topicConfigurations().equals(this.topicConfigurations())) {
            return false;
        }
        if (other.queueConfigurations() == null ^ this.queueConfigurations() == null) {
            return false;
        }
        if (other.queueConfigurations() != null && !other.queueConfigurations().equals(this.queueConfigurations())) {
            return false;
        }
        if (other.lambdaFunctionConfigurations() == null ^ this.lambdaFunctionConfigurations() == null) {
            return false;
        }
        return other.lambdaFunctionConfigurations() == null || other.lambdaFunctionConfigurations().equals(this.lambdaFunctionConfigurations());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.topicConfigurations() != null) {
            sb.append("TopicConfigurations: ").append(this.topicConfigurations()).append(",");
        }
        if (this.queueConfigurations() != null) {
            sb.append("QueueConfigurations: ").append(this.queueConfigurations()).append(",");
        }
        if (this.lambdaFunctionConfigurations() != null) {
            sb.append("LambdaFunctionConfigurations: ").append(this.lambdaFunctionConfigurations()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TopicConfigurations": {
                return Optional.of(clazz.cast(this.topicConfigurations()));
            }
            case "QueueConfigurations": {
                return Optional.of(clazz.cast(this.queueConfigurations()));
            }
            case "LambdaFunctionConfigurations": {
                return Optional.of(clazz.cast(this.lambdaFunctionConfigurations()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<TopicConfiguration> topicConfigurations;
        private List<QueueConfiguration> queueConfigurations;
        private List<LambdaFunctionConfiguration> lambdaFunctionConfigurations;

        private BuilderImpl() {
        }

        private BuilderImpl(NotificationConfiguration model) {
            this.topicConfigurations(model.topicConfigurations);
            this.queueConfigurations(model.queueConfigurations);
            this.lambdaFunctionConfigurations(model.lambdaFunctionConfigurations);
        }

        public final Collection<TopicConfiguration.Builder> getTopicConfigurations() {
            return this.topicConfigurations != null ? (Collection)this.topicConfigurations.stream().map(TopicConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder topicConfigurations(Collection<TopicConfiguration> topicConfigurations) {
            this.topicConfigurations = TopicConfigurationListCopier.copy(topicConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topicConfigurations(TopicConfiguration ... topicConfigurations) {
            this.topicConfigurations(Arrays.asList(topicConfigurations));
            return this;
        }

        public final void setTopicConfigurations(Collection<TopicConfiguration.BuilderImpl> topicConfigurations) {
            this.topicConfigurations = TopicConfigurationListCopier.copyFromBuilder(topicConfigurations);
        }

        public final Collection<QueueConfiguration.Builder> getQueueConfigurations() {
            return this.queueConfigurations != null ? (Collection)this.queueConfigurations.stream().map(QueueConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder queueConfigurations(Collection<QueueConfiguration> queueConfigurations) {
            this.queueConfigurations = QueueConfigurationListCopier.copy(queueConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queueConfigurations(QueueConfiguration ... queueConfigurations) {
            this.queueConfigurations(Arrays.asList(queueConfigurations));
            return this;
        }

        public final void setQueueConfigurations(Collection<QueueConfiguration.BuilderImpl> queueConfigurations) {
            this.queueConfigurations = QueueConfigurationListCopier.copyFromBuilder(queueConfigurations);
        }

        public final Collection<LambdaFunctionConfiguration.Builder> getLambdaFunctionConfigurations() {
            return this.lambdaFunctionConfigurations != null ? (Collection)this.lambdaFunctionConfigurations.stream().map(LambdaFunctionConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder lambdaFunctionConfigurations(Collection<LambdaFunctionConfiguration> lambdaFunctionConfigurations) {
            this.lambdaFunctionConfigurations = LambdaFunctionConfigurationListCopier.copy(lambdaFunctionConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lambdaFunctionConfigurations(LambdaFunctionConfiguration ... lambdaFunctionConfigurations) {
            this.lambdaFunctionConfigurations(Arrays.asList(lambdaFunctionConfigurations));
            return this;
        }

        public final void setLambdaFunctionConfigurations(Collection<LambdaFunctionConfiguration.BuilderImpl> lambdaFunctionConfigurations) {
            this.lambdaFunctionConfigurations = LambdaFunctionConfigurationListCopier.copyFromBuilder(lambdaFunctionConfigurations);
        }

        public NotificationConfiguration build() {
            return new NotificationConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, NotificationConfiguration> {
        public Builder topicConfigurations(Collection<TopicConfiguration> var1);

        public Builder topicConfigurations(TopicConfiguration ... var1);

        public Builder queueConfigurations(Collection<QueueConfiguration> var1);

        public Builder queueConfigurations(QueueConfiguration ... var1);

        public Builder lambdaFunctionConfigurations(Collection<LambdaFunctionConfiguration> var1);

        public Builder lambdaFunctionConfigurations(LambdaFunctionConfiguration ... var1);
    }
}

