/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.time.Instant;
import java.util.Optional;
import software.amazon.awssdk.services.s3.model.Initiator;
import software.amazon.awssdk.services.s3.model.Owner;
import software.amazon.awssdk.services.s3.model.StorageClass;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class MultipartUpload
implements ToCopyableBuilder<Builder, MultipartUpload> {
    private final String uploadId;
    private final String key;
    private final Instant initiated;
    private final String storageClass;
    private final Owner owner;
    private final Initiator initiator;

    private MultipartUpload(BuilderImpl builder) {
        this.uploadId = builder.uploadId;
        this.key = builder.key;
        this.initiated = builder.initiated;
        this.storageClass = builder.storageClass;
        this.owner = builder.owner;
        this.initiator = builder.initiator;
    }

    public String uploadId() {
        return this.uploadId;
    }

    public String key() {
        return this.key;
    }

    public Instant initiated() {
        return this.initiated;
    }

    public StorageClass storageClass() {
        return StorageClass.fromValue(this.storageClass);
    }

    public String storageClassString() {
        return this.storageClass;
    }

    public Owner owner() {
        return this.owner;
    }

    public Initiator initiator() {
        return this.initiator;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.uploadId() == null ? 0 : this.uploadId().hashCode());
        hashCode = 31 * hashCode + (this.key() == null ? 0 : this.key().hashCode());
        hashCode = 31 * hashCode + (this.initiated() == null ? 0 : this.initiated().hashCode());
        hashCode = 31 * hashCode + (this.storageClassString() == null ? 0 : this.storageClassString().hashCode());
        hashCode = 31 * hashCode + (this.owner() == null ? 0 : this.owner().hashCode());
        hashCode = 31 * hashCode + (this.initiator() == null ? 0 : this.initiator().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MultipartUpload)) {
            return false;
        }
        MultipartUpload other = (MultipartUpload)obj;
        if (other.uploadId() == null ^ this.uploadId() == null) {
            return false;
        }
        if (other.uploadId() != null && !other.uploadId().equals(this.uploadId())) {
            return false;
        }
        if (other.key() == null ^ this.key() == null) {
            return false;
        }
        if (other.key() != null && !other.key().equals(this.key())) {
            return false;
        }
        if (other.initiated() == null ^ this.initiated() == null) {
            return false;
        }
        if (other.initiated() != null && !other.initiated().equals(this.initiated())) {
            return false;
        }
        if (other.storageClassString() == null ^ this.storageClassString() == null) {
            return false;
        }
        if (other.storageClassString() != null && !other.storageClassString().equals(this.storageClassString())) {
            return false;
        }
        if (other.owner() == null ^ this.owner() == null) {
            return false;
        }
        if (other.owner() != null && !other.owner().equals(this.owner())) {
            return false;
        }
        if (other.initiator() == null ^ this.initiator() == null) {
            return false;
        }
        return other.initiator() == null || other.initiator().equals(this.initiator());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.uploadId() != null) {
            sb.append("UploadId: ").append(this.uploadId()).append(",");
        }
        if (this.key() != null) {
            sb.append("Key: ").append(this.key()).append(",");
        }
        if (this.initiated() != null) {
            sb.append("Initiated: ").append(this.initiated()).append(",");
        }
        if (this.storageClassString() != null) {
            sb.append("StorageClass: ").append(this.storageClassString()).append(",");
        }
        if (this.owner() != null) {
            sb.append("Owner: ").append(this.owner()).append(",");
        }
        if (this.initiator() != null) {
            sb.append("Initiator: ").append(this.initiator()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UploadId": {
                return Optional.of(clazz.cast(this.uploadId()));
            }
            case "Key": {
                return Optional.of(clazz.cast(this.key()));
            }
            case "Initiated": {
                return Optional.of(clazz.cast(this.initiated()));
            }
            case "StorageClass": {
                return Optional.of(clazz.cast(this.storageClassString()));
            }
            case "Owner": {
                return Optional.of(clazz.cast(this.owner()));
            }
            case "Initiator": {
                return Optional.of(clazz.cast(this.initiator()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String uploadId;
        private String key;
        private Instant initiated;
        private String storageClass;
        private Owner owner;
        private Initiator initiator;

        private BuilderImpl() {
        }

        private BuilderImpl(MultipartUpload model) {
            this.uploadId(model.uploadId);
            this.key(model.key);
            this.initiated(model.initiated);
            this.storageClass(model.storageClass);
            this.owner(model.owner);
            this.initiator(model.initiator);
        }

        public final String getUploadId() {
            return this.uploadId;
        }

        @Override
        public final Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        public final void setUploadId(String uploadId) {
            this.uploadId = uploadId;
        }

        public final String getKey() {
            return this.key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final Instant getInitiated() {
            return this.initiated;
        }

        @Override
        public final Builder initiated(Instant initiated) {
            this.initiated = initiated;
            return this;
        }

        public final void setInitiated(Instant initiated) {
            this.initiated = initiated;
        }

        public final String getStorageClass() {
            return this.storageClass;
        }

        @Override
        public final Builder storageClass(String storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        @Override
        public final Builder storageClass(StorageClass storageClass) {
            this.storageClass(storageClass.toString());
            return this;
        }

        public final void setStorageClass(String storageClass) {
            this.storageClass = storageClass;
        }

        public final Owner.Builder getOwner() {
            return this.owner != null ? this.owner.toBuilder() : null;
        }

        @Override
        public final Builder owner(Owner owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(Owner.BuilderImpl owner) {
            this.owner = owner != null ? owner.build() : null;
        }

        public final Initiator.Builder getInitiator() {
            return this.initiator != null ? this.initiator.toBuilder() : null;
        }

        @Override
        public final Builder initiator(Initiator initiator) {
            this.initiator = initiator;
            return this;
        }

        public final void setInitiator(Initiator.BuilderImpl initiator) {
            this.initiator = initiator != null ? initiator.build() : null;
        }

        public MultipartUpload build() {
            return new MultipartUpload(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MultipartUpload> {
        public Builder uploadId(String var1);

        public Builder key(String var1);

        public Builder initiated(Instant var1);

        public Builder storageClass(String var1);

        public Builder storageClass(StorageClass var1);

        public Builder owner(Owner var1);

        public Builder initiator(Initiator var1);
    }
}

