/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.s3.model.EncodingType;
import software.amazon.awssdk.services.s3.model.RequestPayer;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListObjectsV2Request
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ListObjectsV2Request> {
    private final String bucket;
    private final String delimiter;
    private final String encodingType;
    private final Integer maxKeys;
    private final String prefix;
    private final String continuationToken;
    private final Boolean fetchOwner;
    private final String startAfter;
    private final String requestPayer;

    private ListObjectsV2Request(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.delimiter = builder.delimiter;
        this.encodingType = builder.encodingType;
        this.maxKeys = builder.maxKeys;
        this.prefix = builder.prefix;
        this.continuationToken = builder.continuationToken;
        this.fetchOwner = builder.fetchOwner;
        this.startAfter = builder.startAfter;
        this.requestPayer = builder.requestPayer;
    }

    public String bucket() {
        return this.bucket;
    }

    public String delimiter() {
        return this.delimiter;
    }

    public EncodingType encodingType() {
        return EncodingType.fromValue(this.encodingType);
    }

    public String encodingTypeString() {
        return this.encodingType;
    }

    public Integer maxKeys() {
        return this.maxKeys;
    }

    public String prefix() {
        return this.prefix;
    }

    public String continuationToken() {
        return this.continuationToken;
    }

    public Boolean fetchOwner() {
        return this.fetchOwner;
    }

    public String startAfter() {
        return this.startAfter;
    }

    public RequestPayer requestPayer() {
        return RequestPayer.fromValue(this.requestPayer);
    }

    public String requestPayerString() {
        return this.requestPayer;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.bucket() == null ? 0 : this.bucket().hashCode());
        hashCode = 31 * hashCode + (this.delimiter() == null ? 0 : this.delimiter().hashCode());
        hashCode = 31 * hashCode + (this.encodingTypeString() == null ? 0 : this.encodingTypeString().hashCode());
        hashCode = 31 * hashCode + (this.maxKeys() == null ? 0 : this.maxKeys().hashCode());
        hashCode = 31 * hashCode + (this.prefix() == null ? 0 : this.prefix().hashCode());
        hashCode = 31 * hashCode + (this.continuationToken() == null ? 0 : this.continuationToken().hashCode());
        hashCode = 31 * hashCode + (this.fetchOwner() == null ? 0 : this.fetchOwner().hashCode());
        hashCode = 31 * hashCode + (this.startAfter() == null ? 0 : this.startAfter().hashCode());
        hashCode = 31 * hashCode + (this.requestPayerString() == null ? 0 : this.requestPayerString().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListObjectsV2Request)) {
            return false;
        }
        ListObjectsV2Request other = (ListObjectsV2Request)((Object)obj);
        if (other.bucket() == null ^ this.bucket() == null) {
            return false;
        }
        if (other.bucket() != null && !other.bucket().equals(this.bucket())) {
            return false;
        }
        if (other.delimiter() == null ^ this.delimiter() == null) {
            return false;
        }
        if (other.delimiter() != null && !other.delimiter().equals(this.delimiter())) {
            return false;
        }
        if (other.encodingTypeString() == null ^ this.encodingTypeString() == null) {
            return false;
        }
        if (other.encodingTypeString() != null && !other.encodingTypeString().equals(this.encodingTypeString())) {
            return false;
        }
        if (other.maxKeys() == null ^ this.maxKeys() == null) {
            return false;
        }
        if (other.maxKeys() != null && !other.maxKeys().equals(this.maxKeys())) {
            return false;
        }
        if (other.prefix() == null ^ this.prefix() == null) {
            return false;
        }
        if (other.prefix() != null && !other.prefix().equals(this.prefix())) {
            return false;
        }
        if (other.continuationToken() == null ^ this.continuationToken() == null) {
            return false;
        }
        if (other.continuationToken() != null && !other.continuationToken().equals(this.continuationToken())) {
            return false;
        }
        if (other.fetchOwner() == null ^ this.fetchOwner() == null) {
            return false;
        }
        if (other.fetchOwner() != null && !other.fetchOwner().equals(this.fetchOwner())) {
            return false;
        }
        if (other.startAfter() == null ^ this.startAfter() == null) {
            return false;
        }
        if (other.startAfter() != null && !other.startAfter().equals(this.startAfter())) {
            return false;
        }
        if (other.requestPayerString() == null ^ this.requestPayerString() == null) {
            return false;
        }
        return other.requestPayerString() == null || other.requestPayerString().equals(this.requestPayerString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.bucket() != null) {
            sb.append("Bucket: ").append(this.bucket()).append(",");
        }
        if (this.delimiter() != null) {
            sb.append("Delimiter: ").append(this.delimiter()).append(",");
        }
        if (this.encodingTypeString() != null) {
            sb.append("EncodingType: ").append(this.encodingTypeString()).append(",");
        }
        if (this.maxKeys() != null) {
            sb.append("MaxKeys: ").append(this.maxKeys()).append(",");
        }
        if (this.prefix() != null) {
            sb.append("Prefix: ").append(this.prefix()).append(",");
        }
        if (this.continuationToken() != null) {
            sb.append("ContinuationToken: ").append(this.continuationToken()).append(",");
        }
        if (this.fetchOwner() != null) {
            sb.append("FetchOwner: ").append(this.fetchOwner()).append(",");
        }
        if (this.startAfter() != null) {
            sb.append("StartAfter: ").append(this.startAfter()).append(",");
        }
        if (this.requestPayerString() != null) {
            sb.append("RequestPayer: ").append(this.requestPayerString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Bucket": {
                return Optional.of(clazz.cast(this.bucket()));
            }
            case "Delimiter": {
                return Optional.of(clazz.cast(this.delimiter()));
            }
            case "EncodingType": {
                return Optional.of(clazz.cast(this.encodingTypeString()));
            }
            case "MaxKeys": {
                return Optional.of(clazz.cast(this.maxKeys()));
            }
            case "Prefix": {
                return Optional.of(clazz.cast(this.prefix()));
            }
            case "ContinuationToken": {
                return Optional.of(clazz.cast(this.continuationToken()));
            }
            case "FetchOwner": {
                return Optional.of(clazz.cast(this.fetchOwner()));
            }
            case "StartAfter": {
                return Optional.of(clazz.cast(this.startAfter()));
            }
            case "RequestPayer": {
                return Optional.of(clazz.cast(this.requestPayerString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String bucket;
        private String delimiter;
        private String encodingType;
        private Integer maxKeys;
        private String prefix;
        private String continuationToken;
        private Boolean fetchOwner;
        private String startAfter;
        private String requestPayer;

        private BuilderImpl() {
        }

        private BuilderImpl(ListObjectsV2Request model) {
            this.bucket(model.bucket);
            this.delimiter(model.delimiter);
            this.encodingType(model.encodingType);
            this.maxKeys(model.maxKeys);
            this.prefix(model.prefix);
            this.continuationToken(model.continuationToken);
            this.fetchOwner(model.fetchOwner);
            this.startAfter(model.startAfter);
            this.requestPayer(model.requestPayer);
        }

        public final String getBucket() {
            return this.bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getDelimiter() {
            return this.delimiter;
        }

        @Override
        public final Builder delimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public final void setDelimiter(String delimiter) {
            this.delimiter = delimiter;
        }

        public final String getEncodingType() {
            return this.encodingType;
        }

        @Override
        public final Builder encodingType(String encodingType) {
            this.encodingType = encodingType;
            return this;
        }

        @Override
        public final Builder encodingType(EncodingType encodingType) {
            this.encodingType(encodingType.toString());
            return this;
        }

        public final void setEncodingType(String encodingType) {
            this.encodingType = encodingType;
        }

        public final Integer getMaxKeys() {
            return this.maxKeys;
        }

        @Override
        public final Builder maxKeys(Integer maxKeys) {
            this.maxKeys = maxKeys;
            return this;
        }

        public final void setMaxKeys(Integer maxKeys) {
            this.maxKeys = maxKeys;
        }

        public final String getPrefix() {
            return this.prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final String getContinuationToken() {
            return this.continuationToken;
        }

        @Override
        public final Builder continuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
            return this;
        }

        public final void setContinuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
        }

        public final Boolean getFetchOwner() {
            return this.fetchOwner;
        }

        @Override
        public final Builder fetchOwner(Boolean fetchOwner) {
            this.fetchOwner = fetchOwner;
            return this;
        }

        public final void setFetchOwner(Boolean fetchOwner) {
            this.fetchOwner = fetchOwner;
        }

        public final String getStartAfter() {
            return this.startAfter;
        }

        @Override
        public final Builder startAfter(String startAfter) {
            this.startAfter = startAfter;
            return this;
        }

        public final void setStartAfter(String startAfter) {
            this.startAfter = startAfter;
        }

        public final String getRequestPayer() {
            return this.requestPayer;
        }

        @Override
        public final Builder requestPayer(String requestPayer) {
            this.requestPayer = requestPayer;
            return this;
        }

        @Override
        public final Builder requestPayer(RequestPayer requestPayer) {
            this.requestPayer(requestPayer.toString());
            return this;
        }

        public final void setRequestPayer(String requestPayer) {
            this.requestPayer = requestPayer;
        }

        public ListObjectsV2Request build() {
            return new ListObjectsV2Request(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListObjectsV2Request> {
        public Builder bucket(String var1);

        public Builder delimiter(String var1);

        public Builder encodingType(String var1);

        public Builder encodingType(EncodingType var1);

        public Builder maxKeys(Integer var1);

        public Builder prefix(String var1);

        public Builder continuationToken(String var1);

        public Builder fetchOwner(Boolean var1);

        public Builder startAfter(String var1);

        public Builder requestPayer(String var1);

        public Builder requestPayer(RequestPayer var1);
    }
}

