/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.s3.model.AnalyticsConfiguration;
import software.amazon.awssdk.services.s3.model.AnalyticsConfigurationListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListBucketAnalyticsConfigurationsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListBucketAnalyticsConfigurationsResponse> {
    private final Boolean isTruncated;
    private final String continuationToken;
    private final String nextContinuationToken;
    private final List<AnalyticsConfiguration> analyticsConfigurationList;

    private ListBucketAnalyticsConfigurationsResponse(BuilderImpl builder) {
        this.isTruncated = builder.isTruncated;
        this.continuationToken = builder.continuationToken;
        this.nextContinuationToken = builder.nextContinuationToken;
        this.analyticsConfigurationList = builder.analyticsConfigurationList;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public String continuationToken() {
        return this.continuationToken;
    }

    public String nextContinuationToken() {
        return this.nextContinuationToken;
    }

    public List<AnalyticsConfiguration> analyticsConfigurationList() {
        return this.analyticsConfigurationList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.isTruncated() == null ? 0 : this.isTruncated().hashCode());
        hashCode = 31 * hashCode + (this.continuationToken() == null ? 0 : this.continuationToken().hashCode());
        hashCode = 31 * hashCode + (this.nextContinuationToken() == null ? 0 : this.nextContinuationToken().hashCode());
        hashCode = 31 * hashCode + (this.analyticsConfigurationList() == null ? 0 : this.analyticsConfigurationList().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBucketAnalyticsConfigurationsResponse)) {
            return false;
        }
        ListBucketAnalyticsConfigurationsResponse other = (ListBucketAnalyticsConfigurationsResponse)((Object)obj);
        if (other.isTruncated() == null ^ this.isTruncated() == null) {
            return false;
        }
        if (other.isTruncated() != null && !other.isTruncated().equals(this.isTruncated())) {
            return false;
        }
        if (other.continuationToken() == null ^ this.continuationToken() == null) {
            return false;
        }
        if (other.continuationToken() != null && !other.continuationToken().equals(this.continuationToken())) {
            return false;
        }
        if (other.nextContinuationToken() == null ^ this.nextContinuationToken() == null) {
            return false;
        }
        if (other.nextContinuationToken() != null && !other.nextContinuationToken().equals(this.nextContinuationToken())) {
            return false;
        }
        if (other.analyticsConfigurationList() == null ^ this.analyticsConfigurationList() == null) {
            return false;
        }
        return other.analyticsConfigurationList() == null || other.analyticsConfigurationList().equals(this.analyticsConfigurationList());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.isTruncated() != null) {
            sb.append("IsTruncated: ").append(this.isTruncated()).append(",");
        }
        if (this.continuationToken() != null) {
            sb.append("ContinuationToken: ").append(this.continuationToken()).append(",");
        }
        if (this.nextContinuationToken() != null) {
            sb.append("NextContinuationToken: ").append(this.nextContinuationToken()).append(",");
        }
        if (this.analyticsConfigurationList() != null) {
            sb.append("AnalyticsConfigurationList: ").append(this.analyticsConfigurationList()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IsTruncated": {
                return Optional.of(clazz.cast(this.isTruncated()));
            }
            case "ContinuationToken": {
                return Optional.of(clazz.cast(this.continuationToken()));
            }
            case "NextContinuationToken": {
                return Optional.of(clazz.cast(this.nextContinuationToken()));
            }
            case "AnalyticsConfigurationList": {
                return Optional.of(clazz.cast(this.analyticsConfigurationList()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean isTruncated;
        private String continuationToken;
        private String nextContinuationToken;
        private List<AnalyticsConfiguration> analyticsConfigurationList;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBucketAnalyticsConfigurationsResponse model) {
            this.isTruncated(model.isTruncated);
            this.continuationToken(model.continuationToken);
            this.nextContinuationToken(model.nextContinuationToken);
            this.analyticsConfigurationList(model.analyticsConfigurationList);
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getContinuationToken() {
            return this.continuationToken;
        }

        @Override
        public final Builder continuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
            return this;
        }

        public final void setContinuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
        }

        public final String getNextContinuationToken() {
            return this.nextContinuationToken;
        }

        @Override
        public final Builder nextContinuationToken(String nextContinuationToken) {
            this.nextContinuationToken = nextContinuationToken;
            return this;
        }

        public final void setNextContinuationToken(String nextContinuationToken) {
            this.nextContinuationToken = nextContinuationToken;
        }

        public final Collection<AnalyticsConfiguration.Builder> getAnalyticsConfigurationList() {
            return this.analyticsConfigurationList != null ? (Collection)this.analyticsConfigurationList.stream().map(AnalyticsConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder analyticsConfigurationList(Collection<AnalyticsConfiguration> analyticsConfigurationList) {
            this.analyticsConfigurationList = AnalyticsConfigurationListCopier.copy(analyticsConfigurationList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analyticsConfigurationList(AnalyticsConfiguration ... analyticsConfigurationList) {
            this.analyticsConfigurationList(Arrays.asList(analyticsConfigurationList));
            return this;
        }

        public final void setAnalyticsConfigurationList(Collection<AnalyticsConfiguration.BuilderImpl> analyticsConfigurationList) {
            this.analyticsConfigurationList = AnalyticsConfigurationListCopier.copyFromBuilder(analyticsConfigurationList);
        }

        public ListBucketAnalyticsConfigurationsResponse build() {
            return new ListBucketAnalyticsConfigurationsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListBucketAnalyticsConfigurationsResponse> {
        public Builder isTruncated(Boolean var1);

        public Builder continuationToken(String var1);

        public Builder nextContinuationToken(String var1);

        public Builder analyticsConfigurationList(Collection<AnalyticsConfiguration> var1);

        public Builder analyticsConfigurationList(AnalyticsConfiguration ... var1);
    }
}

