/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Optional;
import software.amazon.awssdk.services.s3.model.Type;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Grantee
implements ToCopyableBuilder<Builder, Grantee> {
    private final String displayName;
    private final String emailAddress;
    private final String id;
    private final String type;
    private final String uri;

    private Grantee(BuilderImpl builder) {
        this.displayName = builder.displayName;
        this.emailAddress = builder.emailAddress;
        this.id = builder.id;
        this.type = builder.type;
        this.uri = builder.uri;
    }

    public String displayName() {
        return this.displayName;
    }

    public String emailAddress() {
        return this.emailAddress;
    }

    public String id() {
        return this.id;
    }

    public Type type() {
        return Type.fromValue(this.type);
    }

    public String typeString() {
        return this.type;
    }

    public String uri() {
        return this.uri;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.displayName() == null ? 0 : this.displayName().hashCode());
        hashCode = 31 * hashCode + (this.emailAddress() == null ? 0 : this.emailAddress().hashCode());
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.typeString() == null ? 0 : this.typeString().hashCode());
        hashCode = 31 * hashCode + (this.uri() == null ? 0 : this.uri().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Grantee)) {
            return false;
        }
        Grantee other = (Grantee)obj;
        if (other.displayName() == null ^ this.displayName() == null) {
            return false;
        }
        if (other.displayName() != null && !other.displayName().equals(this.displayName())) {
            return false;
        }
        if (other.emailAddress() == null ^ this.emailAddress() == null) {
            return false;
        }
        if (other.emailAddress() != null && !other.emailAddress().equals(this.emailAddress())) {
            return false;
        }
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.typeString() == null ^ this.typeString() == null) {
            return false;
        }
        if (other.typeString() != null && !other.typeString().equals(this.typeString())) {
            return false;
        }
        if (other.uri() == null ^ this.uri() == null) {
            return false;
        }
        return other.uri() == null || other.uri().equals(this.uri());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.displayName() != null) {
            sb.append("DisplayName: ").append(this.displayName()).append(",");
        }
        if (this.emailAddress() != null) {
            sb.append("EmailAddress: ").append(this.emailAddress()).append(",");
        }
        if (this.id() != null) {
            sb.append("ID: ").append(this.id()).append(",");
        }
        if (this.typeString() != null) {
            sb.append("Type: ").append(this.typeString()).append(",");
        }
        if (this.uri() != null) {
            sb.append("URI: ").append(this.uri()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DisplayName": {
                return Optional.of(clazz.cast(this.displayName()));
            }
            case "EmailAddress": {
                return Optional.of(clazz.cast(this.emailAddress()));
            }
            case "ID": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "Type": {
                return Optional.of(clazz.cast(this.typeString()));
            }
            case "URI": {
                return Optional.of(clazz.cast(this.uri()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String displayName;
        private String emailAddress;
        private String id;
        private String type;
        private String uri;

        private BuilderImpl() {
        }

        private BuilderImpl(Grantee model) {
            this.displayName(model.displayName);
            this.emailAddress(model.emailAddress);
            this.id(model.id);
            this.type(model.type);
            this.uri(model.uri);
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final String getEmailAddress() {
            return this.emailAddress;
        }

        @Override
        public final Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public final void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        public final String getID() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setID(String id) {
            this.id = id;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(Type type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getURI() {
            return this.uri;
        }

        @Override
        public final Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public final void setURI(String uri) {
            this.uri = uri;
        }

        public Grantee build() {
            return new Grantee(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Grantee> {
        public Builder displayName(String var1);

        public Builder emailAddress(String var1);

        public Builder id(String var1);

        public Builder type(String var1);

        public Builder type(Type var1);

        public Builder uri(String var1);
    }
}

