/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.time.Instant;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.s3.model.RequestPayer;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetObjectRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetObjectRequest> {
    private final String bucket;
    private final String ifMatch;
    private final Instant ifModifiedSince;
    private final String ifNoneMatch;
    private final Instant ifUnmodifiedSince;
    private final String key;
    private final String range;
    private final String responseCacheControl;
    private final String responseContentDisposition;
    private final String responseContentEncoding;
    private final String responseContentLanguage;
    private final String responseContentType;
    private final Instant responseExpires;
    private final String versionId;
    private final String sseCustomerAlgorithm;
    private final String sseCustomerKey;
    private final String sseCustomerKeyMD5;
    private final String requestPayer;
    private final Integer partNumber;

    private GetObjectRequest(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.ifMatch = builder.ifMatch;
        this.ifModifiedSince = builder.ifModifiedSince;
        this.ifNoneMatch = builder.ifNoneMatch;
        this.ifUnmodifiedSince = builder.ifUnmodifiedSince;
        this.key = builder.key;
        this.range = builder.range;
        this.responseCacheControl = builder.responseCacheControl;
        this.responseContentDisposition = builder.responseContentDisposition;
        this.responseContentEncoding = builder.responseContentEncoding;
        this.responseContentLanguage = builder.responseContentLanguage;
        this.responseContentType = builder.responseContentType;
        this.responseExpires = builder.responseExpires;
        this.versionId = builder.versionId;
        this.sseCustomerAlgorithm = builder.sseCustomerAlgorithm;
        this.sseCustomerKey = builder.sseCustomerKey;
        this.sseCustomerKeyMD5 = builder.sseCustomerKeyMD5;
        this.requestPayer = builder.requestPayer;
        this.partNumber = builder.partNumber;
    }

    public String bucket() {
        return this.bucket;
    }

    public String ifMatch() {
        return this.ifMatch;
    }

    public Instant ifModifiedSince() {
        return this.ifModifiedSince;
    }

    public String ifNoneMatch() {
        return this.ifNoneMatch;
    }

    public Instant ifUnmodifiedSince() {
        return this.ifUnmodifiedSince;
    }

    public String key() {
        return this.key;
    }

    public String range() {
        return this.range;
    }

    public String responseCacheControl() {
        return this.responseCacheControl;
    }

    public String responseContentDisposition() {
        return this.responseContentDisposition;
    }

    public String responseContentEncoding() {
        return this.responseContentEncoding;
    }

    public String responseContentLanguage() {
        return this.responseContentLanguage;
    }

    public String responseContentType() {
        return this.responseContentType;
    }

    public Instant responseExpires() {
        return this.responseExpires;
    }

    public String versionId() {
        return this.versionId;
    }

    public String sseCustomerAlgorithm() {
        return this.sseCustomerAlgorithm;
    }

    public String sseCustomerKey() {
        return this.sseCustomerKey;
    }

    public String sseCustomerKeyMD5() {
        return this.sseCustomerKeyMD5;
    }

    public RequestPayer requestPayer() {
        return RequestPayer.fromValue(this.requestPayer);
    }

    public String requestPayerString() {
        return this.requestPayer;
    }

    public Integer partNumber() {
        return this.partNumber;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.bucket() == null ? 0 : this.bucket().hashCode());
        hashCode = 31 * hashCode + (this.ifMatch() == null ? 0 : this.ifMatch().hashCode());
        hashCode = 31 * hashCode + (this.ifModifiedSince() == null ? 0 : this.ifModifiedSince().hashCode());
        hashCode = 31 * hashCode + (this.ifNoneMatch() == null ? 0 : this.ifNoneMatch().hashCode());
        hashCode = 31 * hashCode + (this.ifUnmodifiedSince() == null ? 0 : this.ifUnmodifiedSince().hashCode());
        hashCode = 31 * hashCode + (this.key() == null ? 0 : this.key().hashCode());
        hashCode = 31 * hashCode + (this.range() == null ? 0 : this.range().hashCode());
        hashCode = 31 * hashCode + (this.responseCacheControl() == null ? 0 : this.responseCacheControl().hashCode());
        hashCode = 31 * hashCode + (this.responseContentDisposition() == null ? 0 : this.responseContentDisposition().hashCode());
        hashCode = 31 * hashCode + (this.responseContentEncoding() == null ? 0 : this.responseContentEncoding().hashCode());
        hashCode = 31 * hashCode + (this.responseContentLanguage() == null ? 0 : this.responseContentLanguage().hashCode());
        hashCode = 31 * hashCode + (this.responseContentType() == null ? 0 : this.responseContentType().hashCode());
        hashCode = 31 * hashCode + (this.responseExpires() == null ? 0 : this.responseExpires().hashCode());
        hashCode = 31 * hashCode + (this.versionId() == null ? 0 : this.versionId().hashCode());
        hashCode = 31 * hashCode + (this.sseCustomerAlgorithm() == null ? 0 : this.sseCustomerAlgorithm().hashCode());
        hashCode = 31 * hashCode + (this.sseCustomerKey() == null ? 0 : this.sseCustomerKey().hashCode());
        hashCode = 31 * hashCode + (this.sseCustomerKeyMD5() == null ? 0 : this.sseCustomerKeyMD5().hashCode());
        hashCode = 31 * hashCode + (this.requestPayerString() == null ? 0 : this.requestPayerString().hashCode());
        hashCode = 31 * hashCode + (this.partNumber() == null ? 0 : this.partNumber().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetObjectRequest)) {
            return false;
        }
        GetObjectRequest other = (GetObjectRequest)((Object)obj);
        if (other.bucket() == null ^ this.bucket() == null) {
            return false;
        }
        if (other.bucket() != null && !other.bucket().equals(this.bucket())) {
            return false;
        }
        if (other.ifMatch() == null ^ this.ifMatch() == null) {
            return false;
        }
        if (other.ifMatch() != null && !other.ifMatch().equals(this.ifMatch())) {
            return false;
        }
        if (other.ifModifiedSince() == null ^ this.ifModifiedSince() == null) {
            return false;
        }
        if (other.ifModifiedSince() != null && !other.ifModifiedSince().equals(this.ifModifiedSince())) {
            return false;
        }
        if (other.ifNoneMatch() == null ^ this.ifNoneMatch() == null) {
            return false;
        }
        if (other.ifNoneMatch() != null && !other.ifNoneMatch().equals(this.ifNoneMatch())) {
            return false;
        }
        if (other.ifUnmodifiedSince() == null ^ this.ifUnmodifiedSince() == null) {
            return false;
        }
        if (other.ifUnmodifiedSince() != null && !other.ifUnmodifiedSince().equals(this.ifUnmodifiedSince())) {
            return false;
        }
        if (other.key() == null ^ this.key() == null) {
            return false;
        }
        if (other.key() != null && !other.key().equals(this.key())) {
            return false;
        }
        if (other.range() == null ^ this.range() == null) {
            return false;
        }
        if (other.range() != null && !other.range().equals(this.range())) {
            return false;
        }
        if (other.responseCacheControl() == null ^ this.responseCacheControl() == null) {
            return false;
        }
        if (other.responseCacheControl() != null && !other.responseCacheControl().equals(this.responseCacheControl())) {
            return false;
        }
        if (other.responseContentDisposition() == null ^ this.responseContentDisposition() == null) {
            return false;
        }
        if (other.responseContentDisposition() != null && !other.responseContentDisposition().equals(this.responseContentDisposition())) {
            return false;
        }
        if (other.responseContentEncoding() == null ^ this.responseContentEncoding() == null) {
            return false;
        }
        if (other.responseContentEncoding() != null && !other.responseContentEncoding().equals(this.responseContentEncoding())) {
            return false;
        }
        if (other.responseContentLanguage() == null ^ this.responseContentLanguage() == null) {
            return false;
        }
        if (other.responseContentLanguage() != null && !other.responseContentLanguage().equals(this.responseContentLanguage())) {
            return false;
        }
        if (other.responseContentType() == null ^ this.responseContentType() == null) {
            return false;
        }
        if (other.responseContentType() != null && !other.responseContentType().equals(this.responseContentType())) {
            return false;
        }
        if (other.responseExpires() == null ^ this.responseExpires() == null) {
            return false;
        }
        if (other.responseExpires() != null && !other.responseExpires().equals(this.responseExpires())) {
            return false;
        }
        if (other.versionId() == null ^ this.versionId() == null) {
            return false;
        }
        if (other.versionId() != null && !other.versionId().equals(this.versionId())) {
            return false;
        }
        if (other.sseCustomerAlgorithm() == null ^ this.sseCustomerAlgorithm() == null) {
            return false;
        }
        if (other.sseCustomerAlgorithm() != null && !other.sseCustomerAlgorithm().equals(this.sseCustomerAlgorithm())) {
            return false;
        }
        if (other.sseCustomerKey() == null ^ this.sseCustomerKey() == null) {
            return false;
        }
        if (other.sseCustomerKey() != null && !other.sseCustomerKey().equals(this.sseCustomerKey())) {
            return false;
        }
        if (other.sseCustomerKeyMD5() == null ^ this.sseCustomerKeyMD5() == null) {
            return false;
        }
        if (other.sseCustomerKeyMD5() != null && !other.sseCustomerKeyMD5().equals(this.sseCustomerKeyMD5())) {
            return false;
        }
        if (other.requestPayerString() == null ^ this.requestPayerString() == null) {
            return false;
        }
        if (other.requestPayerString() != null && !other.requestPayerString().equals(this.requestPayerString())) {
            return false;
        }
        if (other.partNumber() == null ^ this.partNumber() == null) {
            return false;
        }
        return other.partNumber() == null || other.partNumber().equals(this.partNumber());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.bucket() != null) {
            sb.append("Bucket: ").append(this.bucket()).append(",");
        }
        if (this.ifMatch() != null) {
            sb.append("IfMatch: ").append(this.ifMatch()).append(",");
        }
        if (this.ifModifiedSince() != null) {
            sb.append("IfModifiedSince: ").append(this.ifModifiedSince()).append(",");
        }
        if (this.ifNoneMatch() != null) {
            sb.append("IfNoneMatch: ").append(this.ifNoneMatch()).append(",");
        }
        if (this.ifUnmodifiedSince() != null) {
            sb.append("IfUnmodifiedSince: ").append(this.ifUnmodifiedSince()).append(",");
        }
        if (this.key() != null) {
            sb.append("Key: ").append(this.key()).append(",");
        }
        if (this.range() != null) {
            sb.append("Range: ").append(this.range()).append(",");
        }
        if (this.responseCacheControl() != null) {
            sb.append("ResponseCacheControl: ").append(this.responseCacheControl()).append(",");
        }
        if (this.responseContentDisposition() != null) {
            sb.append("ResponseContentDisposition: ").append(this.responseContentDisposition()).append(",");
        }
        if (this.responseContentEncoding() != null) {
            sb.append("ResponseContentEncoding: ").append(this.responseContentEncoding()).append(",");
        }
        if (this.responseContentLanguage() != null) {
            sb.append("ResponseContentLanguage: ").append(this.responseContentLanguage()).append(",");
        }
        if (this.responseContentType() != null) {
            sb.append("ResponseContentType: ").append(this.responseContentType()).append(",");
        }
        if (this.responseExpires() != null) {
            sb.append("ResponseExpires: ").append(this.responseExpires()).append(",");
        }
        if (this.versionId() != null) {
            sb.append("VersionId: ").append(this.versionId()).append(",");
        }
        if (this.sseCustomerAlgorithm() != null) {
            sb.append("SSECustomerAlgorithm: ").append(this.sseCustomerAlgorithm()).append(",");
        }
        if (this.sseCustomerKey() != null) {
            sb.append("SSECustomerKey: ").append(this.sseCustomerKey()).append(",");
        }
        if (this.sseCustomerKeyMD5() != null) {
            sb.append("SSECustomerKeyMD5: ").append(this.sseCustomerKeyMD5()).append(",");
        }
        if (this.requestPayerString() != null) {
            sb.append("RequestPayer: ").append(this.requestPayerString()).append(",");
        }
        if (this.partNumber() != null) {
            sb.append("PartNumber: ").append(this.partNumber()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Bucket": {
                return Optional.of(clazz.cast(this.bucket()));
            }
            case "IfMatch": {
                return Optional.of(clazz.cast(this.ifMatch()));
            }
            case "IfModifiedSince": {
                return Optional.of(clazz.cast(this.ifModifiedSince()));
            }
            case "IfNoneMatch": {
                return Optional.of(clazz.cast(this.ifNoneMatch()));
            }
            case "IfUnmodifiedSince": {
                return Optional.of(clazz.cast(this.ifUnmodifiedSince()));
            }
            case "Key": {
                return Optional.of(clazz.cast(this.key()));
            }
            case "Range": {
                return Optional.of(clazz.cast(this.range()));
            }
            case "ResponseCacheControl": {
                return Optional.of(clazz.cast(this.responseCacheControl()));
            }
            case "ResponseContentDisposition": {
                return Optional.of(clazz.cast(this.responseContentDisposition()));
            }
            case "ResponseContentEncoding": {
                return Optional.of(clazz.cast(this.responseContentEncoding()));
            }
            case "ResponseContentLanguage": {
                return Optional.of(clazz.cast(this.responseContentLanguage()));
            }
            case "ResponseContentType": {
                return Optional.of(clazz.cast(this.responseContentType()));
            }
            case "ResponseExpires": {
                return Optional.of(clazz.cast(this.responseExpires()));
            }
            case "VersionId": {
                return Optional.of(clazz.cast(this.versionId()));
            }
            case "SSECustomerAlgorithm": {
                return Optional.of(clazz.cast(this.sseCustomerAlgorithm()));
            }
            case "SSECustomerKey": {
                return Optional.of(clazz.cast(this.sseCustomerKey()));
            }
            case "SSECustomerKeyMD5": {
                return Optional.of(clazz.cast(this.sseCustomerKeyMD5()));
            }
            case "RequestPayer": {
                return Optional.of(clazz.cast(this.requestPayerString()));
            }
            case "PartNumber": {
                return Optional.of(clazz.cast(this.partNumber()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String bucket;
        private String ifMatch;
        private Instant ifModifiedSince;
        private String ifNoneMatch;
        private Instant ifUnmodifiedSince;
        private String key;
        private String range;
        private String responseCacheControl;
        private String responseContentDisposition;
        private String responseContentEncoding;
        private String responseContentLanguage;
        private String responseContentType;
        private Instant responseExpires;
        private String versionId;
        private String sseCustomerAlgorithm;
        private String sseCustomerKey;
        private String sseCustomerKeyMD5;
        private String requestPayer;
        private Integer partNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(GetObjectRequest model) {
            this.bucket(model.bucket);
            this.ifMatch(model.ifMatch);
            this.ifModifiedSince(model.ifModifiedSince);
            this.ifNoneMatch(model.ifNoneMatch);
            this.ifUnmodifiedSince(model.ifUnmodifiedSince);
            this.key(model.key);
            this.range(model.range);
            this.responseCacheControl(model.responseCacheControl);
            this.responseContentDisposition(model.responseContentDisposition);
            this.responseContentEncoding(model.responseContentEncoding);
            this.responseContentLanguage(model.responseContentLanguage);
            this.responseContentType(model.responseContentType);
            this.responseExpires(model.responseExpires);
            this.versionId(model.versionId);
            this.sseCustomerAlgorithm(model.sseCustomerAlgorithm);
            this.sseCustomerKey(model.sseCustomerKey);
            this.sseCustomerKeyMD5(model.sseCustomerKeyMD5);
            this.requestPayer(model.requestPayer);
            this.partNumber(model.partNumber);
        }

        public final String getBucket() {
            return this.bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getIfMatch() {
            return this.ifMatch;
        }

        @Override
        public final Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public final void setIfMatch(String ifMatch) {
            this.ifMatch = ifMatch;
        }

        public final Instant getIfModifiedSince() {
            return this.ifModifiedSince;
        }

        @Override
        public final Builder ifModifiedSince(Instant ifModifiedSince) {
            this.ifModifiedSince = ifModifiedSince;
            return this;
        }

        public final void setIfModifiedSince(Instant ifModifiedSince) {
            this.ifModifiedSince = ifModifiedSince;
        }

        public final String getIfNoneMatch() {
            return this.ifNoneMatch;
        }

        @Override
        public final Builder ifNoneMatch(String ifNoneMatch) {
            this.ifNoneMatch = ifNoneMatch;
            return this;
        }

        public final void setIfNoneMatch(String ifNoneMatch) {
            this.ifNoneMatch = ifNoneMatch;
        }

        public final Instant getIfUnmodifiedSince() {
            return this.ifUnmodifiedSince;
        }

        @Override
        public final Builder ifUnmodifiedSince(Instant ifUnmodifiedSince) {
            this.ifUnmodifiedSince = ifUnmodifiedSince;
            return this;
        }

        public final void setIfUnmodifiedSince(Instant ifUnmodifiedSince) {
            this.ifUnmodifiedSince = ifUnmodifiedSince;
        }

        public final String getKey() {
            return this.key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getRange() {
            return this.range;
        }

        @Override
        public final Builder range(String range) {
            this.range = range;
            return this;
        }

        public final void setRange(String range) {
            this.range = range;
        }

        public final String getResponseCacheControl() {
            return this.responseCacheControl;
        }

        @Override
        public final Builder responseCacheControl(String responseCacheControl) {
            this.responseCacheControl = responseCacheControl;
            return this;
        }

        public final void setResponseCacheControl(String responseCacheControl) {
            this.responseCacheControl = responseCacheControl;
        }

        public final String getResponseContentDisposition() {
            return this.responseContentDisposition;
        }

        @Override
        public final Builder responseContentDisposition(String responseContentDisposition) {
            this.responseContentDisposition = responseContentDisposition;
            return this;
        }

        public final void setResponseContentDisposition(String responseContentDisposition) {
            this.responseContentDisposition = responseContentDisposition;
        }

        public final String getResponseContentEncoding() {
            return this.responseContentEncoding;
        }

        @Override
        public final Builder responseContentEncoding(String responseContentEncoding) {
            this.responseContentEncoding = responseContentEncoding;
            return this;
        }

        public final void setResponseContentEncoding(String responseContentEncoding) {
            this.responseContentEncoding = responseContentEncoding;
        }

        public final String getResponseContentLanguage() {
            return this.responseContentLanguage;
        }

        @Override
        public final Builder responseContentLanguage(String responseContentLanguage) {
            this.responseContentLanguage = responseContentLanguage;
            return this;
        }

        public final void setResponseContentLanguage(String responseContentLanguage) {
            this.responseContentLanguage = responseContentLanguage;
        }

        public final String getResponseContentType() {
            return this.responseContentType;
        }

        @Override
        public final Builder responseContentType(String responseContentType) {
            this.responseContentType = responseContentType;
            return this;
        }

        public final void setResponseContentType(String responseContentType) {
            this.responseContentType = responseContentType;
        }

        public final Instant getResponseExpires() {
            return this.responseExpires;
        }

        @Override
        public final Builder responseExpires(Instant responseExpires) {
            this.responseExpires = responseExpires;
            return this;
        }

        public final void setResponseExpires(Instant responseExpires) {
            this.responseExpires = responseExpires;
        }

        public final String getVersionId() {
            return this.versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        public final String getSSECustomerAlgorithm() {
            return this.sseCustomerAlgorithm;
        }

        @Override
        public final Builder sseCustomerAlgorithm(String sseCustomerAlgorithm) {
            this.sseCustomerAlgorithm = sseCustomerAlgorithm;
            return this;
        }

        public final void setSSECustomerAlgorithm(String sseCustomerAlgorithm) {
            this.sseCustomerAlgorithm = sseCustomerAlgorithm;
        }

        public final String getSSECustomerKey() {
            return this.sseCustomerKey;
        }

        @Override
        public final Builder sseCustomerKey(String sseCustomerKey) {
            this.sseCustomerKey = sseCustomerKey;
            return this;
        }

        public final void setSSECustomerKey(String sseCustomerKey) {
            this.sseCustomerKey = sseCustomerKey;
        }

        public final String getSSECustomerKeyMD5() {
            return this.sseCustomerKeyMD5;
        }

        @Override
        public final Builder sseCustomerKeyMD5(String sseCustomerKeyMD5) {
            this.sseCustomerKeyMD5 = sseCustomerKeyMD5;
            return this;
        }

        public final void setSSECustomerKeyMD5(String sseCustomerKeyMD5) {
            this.sseCustomerKeyMD5 = sseCustomerKeyMD5;
        }

        public final String getRequestPayer() {
            return this.requestPayer;
        }

        @Override
        public final Builder requestPayer(String requestPayer) {
            this.requestPayer = requestPayer;
            return this;
        }

        @Override
        public final Builder requestPayer(RequestPayer requestPayer) {
            this.requestPayer(requestPayer.toString());
            return this;
        }

        public final void setRequestPayer(String requestPayer) {
            this.requestPayer = requestPayer;
        }

        public final Integer getPartNumber() {
            return this.partNumber;
        }

        @Override
        public final Builder partNumber(Integer partNumber) {
            this.partNumber = partNumber;
            return this;
        }

        public final void setPartNumber(Integer partNumber) {
            this.partNumber = partNumber;
        }

        public GetObjectRequest build() {
            return new GetObjectRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetObjectRequest> {
        public Builder bucket(String var1);

        public Builder ifMatch(String var1);

        public Builder ifModifiedSince(Instant var1);

        public Builder ifNoneMatch(String var1);

        public Builder ifUnmodifiedSince(Instant var1);

        public Builder key(String var1);

        public Builder range(String var1);

        public Builder responseCacheControl(String var1);

        public Builder responseContentDisposition(String var1);

        public Builder responseContentEncoding(String var1);

        public Builder responseContentLanguage(String var1);

        public Builder responseContentType(String var1);

        public Builder responseExpires(Instant var1);

        public Builder versionId(String var1);

        public Builder sseCustomerAlgorithm(String var1);

        public Builder sseCustomerKey(String var1);

        public Builder sseCustomerKeyMD5(String var1);

        public Builder requestPayer(String var1);

        public Builder requestPayer(RequestPayer var1);

        public Builder partNumber(Integer var1);
    }
}

