/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.transform;

import static software.amazon.awssdk.core.util.StringUtils.UTF8;

import java.io.StringWriter;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.s3.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;

import software.amazon.awssdk.core.util.StringInputStream;
import software.amazon.awssdk.core.util.StringUtils;

import software.amazon.awssdk.core.util.Md5Utils;
import software.amazon.awssdk.core.util.XmlWriter;

/**
 * PutBucketCorsRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class PutBucketCorsRequestMarshaller implements Marshaller<Request<PutBucketCorsRequest>, PutBucketCorsRequest> {

    public Request<PutBucketCorsRequest> marshall(PutBucketCorsRequest putBucketCorsRequest) {

        if (putBucketCorsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<PutBucketCorsRequest> request = new DefaultRequest<PutBucketCorsRequest>(putBucketCorsRequest, "S3Client");

        request.setHttpMethod(HttpMethodName.PUT);

        if (putBucketCorsRequest.contentMD5() != null) {
            request.addHeader("Content-MD5", StringUtils.fromString(putBucketCorsRequest.contentMD5()));
        }

        String uriResourcePath = "/{Bucket}?cors";

        uriResourcePath = software.amazon.awssdk.core.util.UriResourcePathUtils.addStaticQueryParametersToRequest(request,
                uriResourcePath);

        uriResourcePath = software.amazon.awssdk.core.runtime.transform.PathMarshallers.NON_GREEDY.marshall(uriResourcePath,
                "Bucket", putBucketCorsRequest.bucket());
        request.setResourcePath(uriResourcePath);

        try {
            StringWriter stringWriter = null;
            CORSConfiguration corsConfiguration = putBucketCorsRequest.corsConfiguration();
            if (corsConfiguration != null) {
                stringWriter = new StringWriter();
                XmlWriter xmlWriter = new XmlWriter(stringWriter, "http://s3.amazonaws.com/doc/2006-03-01/");
                xmlWriter.startElement("CORSConfiguration");

                java.util.List<CORSRule> cORSConfigurationCORSRulesList = corsConfiguration.corsRules();
                if (cORSConfigurationCORSRulesList != null) {
                    for (CORSRule cORSConfigurationCORSRulesListValue : cORSConfigurationCORSRulesList) {
                        xmlWriter.startElement("CORSRule");

                        java.util.List<String> cORSRuleAllowedHeadersList = cORSConfigurationCORSRulesListValue.allowedHeaders();
                        if (cORSRuleAllowedHeadersList != null) {
                            for (String cORSRuleAllowedHeadersListValue : cORSRuleAllowedHeadersList) {
                                xmlWriter.startElement("AllowedHeader");
                                xmlWriter.value(cORSRuleAllowedHeadersListValue);
                                xmlWriter.endElement();
                            }
                        }

                        java.util.List<String> cORSRuleAllowedMethodsList = cORSConfigurationCORSRulesListValue.allowedMethods();
                        if (cORSRuleAllowedMethodsList != null) {
                            for (String cORSRuleAllowedMethodsListValue : cORSRuleAllowedMethodsList) {
                                xmlWriter.startElement("AllowedMethod");
                                xmlWriter.value(cORSRuleAllowedMethodsListValue);
                                xmlWriter.endElement();
                            }
                        }

                        java.util.List<String> cORSRuleAllowedOriginsList = cORSConfigurationCORSRulesListValue.allowedOrigins();
                        if (cORSRuleAllowedOriginsList != null) {
                            for (String cORSRuleAllowedOriginsListValue : cORSRuleAllowedOriginsList) {
                                xmlWriter.startElement("AllowedOrigin");
                                xmlWriter.value(cORSRuleAllowedOriginsListValue);
                                xmlWriter.endElement();
                            }
                        }

                        java.util.List<String> cORSRuleExposeHeadersList = cORSConfigurationCORSRulesListValue.exposeHeaders();
                        if (cORSRuleExposeHeadersList != null) {
                            for (String cORSRuleExposeHeadersListValue : cORSRuleExposeHeadersList) {
                                xmlWriter.startElement("ExposeHeader");
                                xmlWriter.value(cORSRuleExposeHeadersListValue);
                                xmlWriter.endElement();
                            }
                        }

                        if (cORSConfigurationCORSRulesListValue.maxAgeSeconds() != null) {
                            xmlWriter.startElement("MaxAgeSeconds").value(cORSConfigurationCORSRulesListValue.maxAgeSeconds())
                                    .endElement();
                        }
                        xmlWriter.endElement();
                    }
                }
                xmlWriter.endElement();
            }

            if (stringWriter != null) {
                if (!request.getHeaders().containsKey("Content-MD5")) {
                    request.addHeader("Content-MD5", Md5Utils.md5AsBase64(stringWriter.getBuffer().toString().getBytes(UTF8)));
                }
                request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
                request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(UTF8).length));
            }
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        } catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }

        return request;
    }

}