/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.s3.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * ListPartsResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ListPartsResponseUnmarshaller implements Unmarshaller<ListPartsResponse, StaxUnmarshallerContext> {

    public ListPartsResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        ListPartsResponse.Builder listPartsResponse = ListPartsResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        if (context.isStartOfDocument()) {
            context.setCurrentHeader("x-amz-abort-date");
            listPartsResponse.abortDate(software.amazon.awssdk.core.util.DateUtils.parseRfc1123Date(context.readText()));

            context.setCurrentHeader("x-amz-abort-rule-id");
            listPartsResponse.abortRuleId(StringUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("x-amz-request-charged");
            listPartsResponse.requestCharged(StringUnmarshaller.getInstance().unmarshall(context));

        }

        java.util.List<Part> parts = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                listPartsResponse.parts(parts);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("Bucket", targetDepth)) {
                    listPartsResponse.bucket(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Key", targetDepth)) {
                    listPartsResponse.key(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("UploadId", targetDepth)) {
                    listPartsResponse.uploadId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("PartNumberMarker", targetDepth)) {
                    listPartsResponse.partNumberMarker(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("NextPartNumberMarker", targetDepth)) {
                    listPartsResponse.nextPartNumberMarker(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("MaxParts", targetDepth)) {
                    listPartsResponse.maxParts(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("IsTruncated", targetDepth)) {
                    listPartsResponse.isTruncated(BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Part", targetDepth)) {
                    if (parts == null) {
                        parts = new ArrayList<>();
                    }
                    parts.add(PartUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Initiator", targetDepth)) {
                    listPartsResponse.initiator(InitiatorUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Owner", targetDepth)) {
                    listPartsResponse.owner(OwnerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("StorageClass", targetDepth)) {
                    listPartsResponse.storageClass(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    listPartsResponse.parts(parts);
                    break;
                }
            }
        }
        return listPartsResponse.build();
    }

    private static final ListPartsResponseUnmarshaller INSTANCE = new ListPartsResponseUnmarshaller();

    public static ListPartsResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
