/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class TopicConfigurationDeprecated implements
        ToCopyableBuilder<TopicConfigurationDeprecated.Builder, TopicConfigurationDeprecated> {
    private final String id;

    private final List<String> events;

    private final String event;

    private final String topic;

    private TopicConfigurationDeprecated(BuilderImpl builder) {
        this.id = builder.id;
        this.events = builder.events;
        this.event = builder.event;
        this.topic = builder.topic;
    }

    /**
     * Returns the value of the Id property for this object.
     * 
     * @return The value of the Id property for this object.
     */
    public String id() {
        return id;
    }

    /**
     * Returns the value of the Events property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the Events property for this object.
     */
    public List<Event> events() {
        return TypeConverter.convert(events, Event::fromValue);
    }

    /**
     * Returns the value of the Events property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the Events property for this object.
     */
    public List<String> eventsStrings() {
        return events;
    }

    /**
     * Bucket event for which to send notifications.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #event} will return
     * {@link Event#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventString}.
     * </p>
     * 
     * @return Bucket event for which to send notifications.
     * @see Event
     */
    public Event event() {
        return Event.fromValue(event);
    }

    /**
     * Bucket event for which to send notifications.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #event} will return
     * {@link Event#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventString}.
     * </p>
     * 
     * @return Bucket event for which to send notifications.
     * @see Event
     */
    public String eventString() {
        return event;
    }

    /**
     * Amazon SNS topic to which Amazon S3 will publish a message to report the specified events for the bucket.
     * 
     * @return Amazon SNS topic to which Amazon S3 will publish a message to report the specified events for the bucket.
     */
    public String topic() {
        return topic;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((id() == null) ? 0 : id().hashCode());
        hashCode = 31 * hashCode + ((eventsStrings() == null) ? 0 : eventsStrings().hashCode());
        hashCode = 31 * hashCode + ((eventString() == null) ? 0 : eventString().hashCode());
        hashCode = 31 * hashCode + ((topic() == null) ? 0 : topic().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicConfigurationDeprecated)) {
            return false;
        }
        TopicConfigurationDeprecated other = (TopicConfigurationDeprecated) obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.eventsStrings() == null ^ this.eventsStrings() == null) {
            return false;
        }
        if (other.eventsStrings() != null && !other.eventsStrings().equals(this.eventsStrings())) {
            return false;
        }
        if (other.eventString() == null ^ this.eventString() == null) {
            return false;
        }
        if (other.eventString() != null && !other.eventString().equals(this.eventString())) {
            return false;
        }
        if (other.topic() == null ^ this.topic() == null) {
            return false;
        }
        if (other.topic() != null && !other.topic().equals(this.topic())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (id() != null) {
            sb.append("Id: ").append(id()).append(",");
        }
        if (eventsStrings() != null) {
            sb.append("Events: ").append(eventsStrings()).append(",");
        }
        if (eventString() != null) {
            sb.append("Event: ").append(eventString()).append(",");
        }
        if (topic() != null) {
            sb.append("Topic: ").append(topic()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.of(clazz.cast(id()));
        case "Events":
            return Optional.of(clazz.cast(eventsStrings()));
        case "Event":
            return Optional.of(clazz.cast(eventString()));
        case "Topic":
            return Optional.of(clazz.cast(topic()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, TopicConfigurationDeprecated> {
        /**
         * Sets the value of the Id property for this object.
         *
         * @param id
         *        The new value for the Id property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * Sets the value of the Events property for this object.
         *
         * @param events
         *        The new value for the Events property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(Collection<String> events);

        /**
         * Sets the value of the Events property for this object.
         *
         * @param events
         *        The new value for the Events property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(String... events);

        /**
         * Bucket event for which to send notifications.
         * 
         * @param event
         *        Bucket event for which to send notifications.
         * @see Event
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Event
         */
        Builder event(String event);

        /**
         * Bucket event for which to send notifications.
         * 
         * @param event
         *        Bucket event for which to send notifications.
         * @see Event
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Event
         */
        Builder event(Event event);

        /**
         * Amazon SNS topic to which Amazon S3 will publish a message to report the specified events for the bucket.
         * 
         * @param topic
         *        Amazon SNS topic to which Amazon S3 will publish a message to report the specified events for the
         *        bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topic(String topic);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private List<String> events;

        private String event;

        private String topic;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicConfigurationDeprecated model) {
            id(model.id);
            events(model.events);
            event(model.event);
            topic(model.topic);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Collection<String> getEvents() {
            return events;
        }

        @Override
        public final Builder events(Collection<String> events) {
            this.events = EventListCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(String... events) {
            events(Arrays.asList(events));
            return this;
        }

        public final void setEvents(Collection<String> events) {
            this.events = EventListCopier.copy(events);
        }

        public final String getEvent() {
            return event;
        }

        @Override
        public final Builder event(String event) {
            this.event = event;
            return this;
        }

        @Override
        public final Builder event(Event event) {
            this.event(event.toString());
            return this;
        }

        public final void setEvent(String event) {
            this.event = event;
        }

        public final String getTopic() {
            return topic;
        }

        @Override
        public final Builder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public final void setTopic(String topic) {
            this.topic = topic;
        }

        @Override
        public TopicConfigurationDeprecated build() {
            return new TopicConfigurationDeprecated(this);
        }
    }
}
