/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class PutBucketLoggingRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<PutBucketLoggingRequest.Builder, PutBucketLoggingRequest> {
    private final String bucket;

    private final BucketLoggingStatus bucketLoggingStatus;

    private final String contentMD5;

    private PutBucketLoggingRequest(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.bucketLoggingStatus = builder.bucketLoggingStatus;
        this.contentMD5 = builder.contentMD5;
    }

    /**
     * Returns the value of the Bucket property for this object.
     * 
     * @return The value of the Bucket property for this object.
     */
    public String bucket() {
        return bucket;
    }

    /**
     * Returns the value of the BucketLoggingStatus property for this object.
     * 
     * @return The value of the BucketLoggingStatus property for this object.
     */
    public BucketLoggingStatus bucketLoggingStatus() {
        return bucketLoggingStatus;
    }

    /**
     * Returns the value of the ContentMD5 property for this object.
     * 
     * @return The value of the ContentMD5 property for this object.
     */
    public String contentMD5() {
        return contentMD5;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((bucket() == null) ? 0 : bucket().hashCode());
        hashCode = 31 * hashCode + ((bucketLoggingStatus() == null) ? 0 : bucketLoggingStatus().hashCode());
        hashCode = 31 * hashCode + ((contentMD5() == null) ? 0 : contentMD5().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutBucketLoggingRequest)) {
            return false;
        }
        PutBucketLoggingRequest other = (PutBucketLoggingRequest) obj;
        if (other.bucket() == null ^ this.bucket() == null) {
            return false;
        }
        if (other.bucket() != null && !other.bucket().equals(this.bucket())) {
            return false;
        }
        if (other.bucketLoggingStatus() == null ^ this.bucketLoggingStatus() == null) {
            return false;
        }
        if (other.bucketLoggingStatus() != null && !other.bucketLoggingStatus().equals(this.bucketLoggingStatus())) {
            return false;
        }
        if (other.contentMD5() == null ^ this.contentMD5() == null) {
            return false;
        }
        if (other.contentMD5() != null && !other.contentMD5().equals(this.contentMD5())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (bucket() != null) {
            sb.append("Bucket: ").append(bucket()).append(",");
        }
        if (bucketLoggingStatus() != null) {
            sb.append("BucketLoggingStatus: ").append(bucketLoggingStatus()).append(",");
        }
        if (contentMD5() != null) {
            sb.append("ContentMD5: ").append(contentMD5()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Bucket":
            return Optional.of(clazz.cast(bucket()));
        case "BucketLoggingStatus":
            return Optional.of(clazz.cast(bucketLoggingStatus()));
        case "ContentMD5":
            return Optional.of(clazz.cast(contentMD5()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, PutBucketLoggingRequest> {
        /**
         * Sets the value of the Bucket property for this object.
         *
         * @param bucket
         *        The new value for the Bucket property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * Sets the value of the BucketLoggingStatus property for this object.
         *
         * @param bucketLoggingStatus
         *        The new value for the BucketLoggingStatus property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketLoggingStatus(BucketLoggingStatus bucketLoggingStatus);

        /**
         * Sets the value of the ContentMD5 property for this object.
         *
         * @param contentMD5
         *        The new value for the ContentMD5 property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentMD5(String contentMD5);
    }

    static final class BuilderImpl implements Builder {
        private String bucket;

        private BucketLoggingStatus bucketLoggingStatus;

        private String contentMD5;

        private BuilderImpl() {
        }

        private BuilderImpl(PutBucketLoggingRequest model) {
            bucket(model.bucket);
            bucketLoggingStatus(model.bucketLoggingStatus);
            contentMD5(model.contentMD5);
        }

        public final String getBucket() {
            return bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final BucketLoggingStatus.Builder getBucketLoggingStatus() {
            return bucketLoggingStatus != null ? bucketLoggingStatus.toBuilder() : null;
        }

        @Override
        public final Builder bucketLoggingStatus(BucketLoggingStatus bucketLoggingStatus) {
            this.bucketLoggingStatus = bucketLoggingStatus;
            return this;
        }

        public final void setBucketLoggingStatus(BucketLoggingStatus.BuilderImpl bucketLoggingStatus) {
            this.bucketLoggingStatus = bucketLoggingStatus != null ? bucketLoggingStatus.build() : null;
        }

        public final String getContentMD5() {
            return contentMD5;
        }

        @Override
        public final Builder contentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
            return this;
        }

        public final void setContentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
        }

        @Override
        public PutBucketLoggingRequest build() {
            return new PutBucketLoggingRequest(this);
        }
    }
}
