/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Container for object key name filtering rules. For information about key name filtering, go to <a
 * href="http://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Configuring Event Notifications</a> in
 * the Amazon Simple Storage Service Developer Guide.
 */
@Generated("software.amazon.awssdk:codegen")
public class NotificationConfigurationFilter implements
        ToCopyableBuilder<NotificationConfigurationFilter.Builder, NotificationConfigurationFilter> {
    private final S3KeyFilter key;

    private NotificationConfigurationFilter(BuilderImpl builder) {
        this.key = builder.key;
    }

    /**
     * Returns the value of the Key property for this object.
     * 
     * @return The value of the Key property for this object.
     */
    public S3KeyFilter key() {
        return key;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((key() == null) ? 0 : key().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotificationConfigurationFilter)) {
            return false;
        }
        NotificationConfigurationFilter other = (NotificationConfigurationFilter) obj;
        if (other.key() == null ^ this.key() == null) {
            return false;
        }
        if (other.key() != null && !other.key().equals(this.key())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (key() != null) {
            sb.append("Key: ").append(key()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Key":
            return Optional.of(clazz.cast(key()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, NotificationConfigurationFilter> {
        /**
         * Sets the value of the Key property for this object.
         *
         * @param key
         *        The new value for the Key property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(S3KeyFilter key);
    }

    static final class BuilderImpl implements Builder {
        private S3KeyFilter key;

        private BuilderImpl() {
        }

        private BuilderImpl(NotificationConfigurationFilter model) {
            key(model.key);
        }

        public final S3KeyFilter.Builder getKey() {
            return key != null ? key.toBuilder() : null;
        }

        @Override
        public final Builder key(S3KeyFilter key) {
            this.key = key;
            return this;
        }

        public final void setKey(S3KeyFilter.BuilderImpl key) {
            this.key = key != null ? key.build() : null;
        }

        @Override
        public NotificationConfigurationFilter build() {
            return new NotificationConfigurationFilter(this);
        }
    }
}
