/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.time.Instant;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class MultipartUpload implements ToCopyableBuilder<MultipartUpload.Builder, MultipartUpload> {
    private final String uploadId;

    private final String key;

    private final Instant initiated;

    private final String storageClass;

    private final Owner owner;

    private final Initiator initiator;

    private MultipartUpload(BuilderImpl builder) {
        this.uploadId = builder.uploadId;
        this.key = builder.key;
        this.initiated = builder.initiated;
        this.storageClass = builder.storageClass;
        this.owner = builder.owner;
        this.initiator = builder.initiator;
    }

    /**
     * Upload ID that identifies the multipart upload.
     * 
     * @return Upload ID that identifies the multipart upload.
     */
    public String uploadId() {
        return uploadId;
    }

    /**
     * Key of the object for which the multipart upload was initiated.
     * 
     * @return Key of the object for which the multipart upload was initiated.
     */
    public String key() {
        return key;
    }

    /**
     * Date and time at which the multipart upload was initiated.
     * 
     * @return Date and time at which the multipart upload was initiated.
     */
    public Instant initiated() {
        return initiated;
    }

    /**
     * The class of storage used to store the object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageClass} will
     * return {@link StorageClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageClassString}.
     * </p>
     * 
     * @return The class of storage used to store the object.
     * @see StorageClass
     */
    public StorageClass storageClass() {
        return StorageClass.fromValue(storageClass);
    }

    /**
     * The class of storage used to store the object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageClass} will
     * return {@link StorageClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageClassString}.
     * </p>
     * 
     * @return The class of storage used to store the object.
     * @see StorageClass
     */
    public String storageClassString() {
        return storageClass;
    }

    /**
     * Returns the value of the Owner property for this object.
     * 
     * @return The value of the Owner property for this object.
     */
    public Owner owner() {
        return owner;
    }

    /**
     * Identifies who initiated the multipart upload.
     * 
     * @return Identifies who initiated the multipart upload.
     */
    public Initiator initiator() {
        return initiator;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((uploadId() == null) ? 0 : uploadId().hashCode());
        hashCode = 31 * hashCode + ((key() == null) ? 0 : key().hashCode());
        hashCode = 31 * hashCode + ((initiated() == null) ? 0 : initiated().hashCode());
        hashCode = 31 * hashCode + ((storageClassString() == null) ? 0 : storageClassString().hashCode());
        hashCode = 31 * hashCode + ((owner() == null) ? 0 : owner().hashCode());
        hashCode = 31 * hashCode + ((initiator() == null) ? 0 : initiator().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MultipartUpload)) {
            return false;
        }
        MultipartUpload other = (MultipartUpload) obj;
        if (other.uploadId() == null ^ this.uploadId() == null) {
            return false;
        }
        if (other.uploadId() != null && !other.uploadId().equals(this.uploadId())) {
            return false;
        }
        if (other.key() == null ^ this.key() == null) {
            return false;
        }
        if (other.key() != null && !other.key().equals(this.key())) {
            return false;
        }
        if (other.initiated() == null ^ this.initiated() == null) {
            return false;
        }
        if (other.initiated() != null && !other.initiated().equals(this.initiated())) {
            return false;
        }
        if (other.storageClassString() == null ^ this.storageClassString() == null) {
            return false;
        }
        if (other.storageClassString() != null && !other.storageClassString().equals(this.storageClassString())) {
            return false;
        }
        if (other.owner() == null ^ this.owner() == null) {
            return false;
        }
        if (other.owner() != null && !other.owner().equals(this.owner())) {
            return false;
        }
        if (other.initiator() == null ^ this.initiator() == null) {
            return false;
        }
        if (other.initiator() != null && !other.initiator().equals(this.initiator())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (uploadId() != null) {
            sb.append("UploadId: ").append(uploadId()).append(",");
        }
        if (key() != null) {
            sb.append("Key: ").append(key()).append(",");
        }
        if (initiated() != null) {
            sb.append("Initiated: ").append(initiated()).append(",");
        }
        if (storageClassString() != null) {
            sb.append("StorageClass: ").append(storageClassString()).append(",");
        }
        if (owner() != null) {
            sb.append("Owner: ").append(owner()).append(",");
        }
        if (initiator() != null) {
            sb.append("Initiator: ").append(initiator()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UploadId":
            return Optional.of(clazz.cast(uploadId()));
        case "Key":
            return Optional.of(clazz.cast(key()));
        case "Initiated":
            return Optional.of(clazz.cast(initiated()));
        case "StorageClass":
            return Optional.of(clazz.cast(storageClassString()));
        case "Owner":
            return Optional.of(clazz.cast(owner()));
        case "Initiator":
            return Optional.of(clazz.cast(initiator()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, MultipartUpload> {
        /**
         * Upload ID that identifies the multipart upload.
         * 
         * @param uploadId
         *        Upload ID that identifies the multipart upload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadId(String uploadId);

        /**
         * Key of the object for which the multipart upload was initiated.
         * 
         * @param key
         *        Key of the object for which the multipart upload was initiated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * Date and time at which the multipart upload was initiated.
         * 
         * @param initiated
         *        Date and time at which the multipart upload was initiated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initiated(Instant initiated);

        /**
         * The class of storage used to store the object.
         * 
         * @param storageClass
         *        The class of storage used to store the object.
         * @see StorageClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageClass
         */
        Builder storageClass(String storageClass);

        /**
         * The class of storage used to store the object.
         * 
         * @param storageClass
         *        The class of storage used to store the object.
         * @see StorageClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageClass
         */
        Builder storageClass(StorageClass storageClass);

        /**
         * Sets the value of the Owner property for this object.
         *
         * @param owner
         *        The new value for the Owner property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(Owner owner);

        /**
         * Identifies who initiated the multipart upload.
         * 
         * @param initiator
         *        Identifies who initiated the multipart upload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initiator(Initiator initiator);
    }

    static final class BuilderImpl implements Builder {
        private String uploadId;

        private String key;

        private Instant initiated;

        private String storageClass;

        private Owner owner;

        private Initiator initiator;

        private BuilderImpl() {
        }

        private BuilderImpl(MultipartUpload model) {
            uploadId(model.uploadId);
            key(model.key);
            initiated(model.initiated);
            storageClass(model.storageClass);
            owner(model.owner);
            initiator(model.initiator);
        }

        public final String getUploadId() {
            return uploadId;
        }

        @Override
        public final Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        public final void setUploadId(String uploadId) {
            this.uploadId = uploadId;
        }

        public final String getKey() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final Instant getInitiated() {
            return initiated;
        }

        @Override
        public final Builder initiated(Instant initiated) {
            this.initiated = initiated;
            return this;
        }

        public final void setInitiated(Instant initiated) {
            this.initiated = initiated;
        }

        public final String getStorageClass() {
            return storageClass;
        }

        @Override
        public final Builder storageClass(String storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        @Override
        public final Builder storageClass(StorageClass storageClass) {
            this.storageClass(storageClass.toString());
            return this;
        }

        public final void setStorageClass(String storageClass) {
            this.storageClass = storageClass;
        }

        public final Owner.Builder getOwner() {
            return owner != null ? owner.toBuilder() : null;
        }

        @Override
        public final Builder owner(Owner owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(Owner.BuilderImpl owner) {
            this.owner = owner != null ? owner.build() : null;
        }

        public final Initiator.Builder getInitiator() {
            return initiator != null ? initiator.toBuilder() : null;
        }

        @Override
        public final Builder initiator(Initiator initiator) {
            this.initiator = initiator;
            return this;
        }

        public final void setInitiator(Initiator.BuilderImpl initiator) {
            this.initiator = initiator != null ? initiator.build() : null;
        }

        @Override
        public MultipartUpload build() {
            return new MultipartUpload(this);
        }
    }
}
