/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class MetricsFilter implements ToCopyableBuilder<MetricsFilter.Builder, MetricsFilter> {
    private final String prefix;

    private final Tag tag;

    private final MetricsAndOperator and;

    private MetricsFilter(BuilderImpl builder) {
        this.prefix = builder.prefix;
        this.tag = builder.tag;
        this.and = builder.and;
    }

    /**
     * The prefix used when evaluating a metrics filter.
     * 
     * @return The prefix used when evaluating a metrics filter.
     */
    public String prefix() {
        return prefix;
    }

    /**
     * The tag used when evaluating a metrics filter.
     * 
     * @return The tag used when evaluating a metrics filter.
     */
    public Tag tag() {
        return tag;
    }

    /**
     * A conjunction (logical AND) of predicates, which is used in evaluating a metrics filter. The operator must have
     * at least two predicates, and an object must match all of the predicates in order for the filter to apply.
     * 
     * @return A conjunction (logical AND) of predicates, which is used in evaluating a metrics filter. The operator
     *         must have at least two predicates, and an object must match all of the predicates in order for the filter
     *         to apply.
     */
    public MetricsAndOperator and() {
        return and;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((prefix() == null) ? 0 : prefix().hashCode());
        hashCode = 31 * hashCode + ((tag() == null) ? 0 : tag().hashCode());
        hashCode = 31 * hashCode + ((and() == null) ? 0 : and().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricsFilter)) {
            return false;
        }
        MetricsFilter other = (MetricsFilter) obj;
        if (other.prefix() == null ^ this.prefix() == null) {
            return false;
        }
        if (other.prefix() != null && !other.prefix().equals(this.prefix())) {
            return false;
        }
        if (other.tag() == null ^ this.tag() == null) {
            return false;
        }
        if (other.tag() != null && !other.tag().equals(this.tag())) {
            return false;
        }
        if (other.and() == null ^ this.and() == null) {
            return false;
        }
        if (other.and() != null && !other.and().equals(this.and())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (prefix() != null) {
            sb.append("Prefix: ").append(prefix()).append(",");
        }
        if (tag() != null) {
            sb.append("Tag: ").append(tag()).append(",");
        }
        if (and() != null) {
            sb.append("And: ").append(and()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Prefix":
            return Optional.of(clazz.cast(prefix()));
        case "Tag":
            return Optional.of(clazz.cast(tag()));
        case "And":
            return Optional.of(clazz.cast(and()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, MetricsFilter> {
        /**
         * The prefix used when evaluating a metrics filter.
         * 
         * @param prefix
         *        The prefix used when evaluating a metrics filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);

        /**
         * The tag used when evaluating a metrics filter.
         * 
         * @param tag
         *        The tag used when evaluating a metrics filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tag(Tag tag);

        /**
         * A conjunction (logical AND) of predicates, which is used in evaluating a metrics filter. The operator must
         * have at least two predicates, and an object must match all of the predicates in order for the filter to
         * apply.
         * 
         * @param and
         *        A conjunction (logical AND) of predicates, which is used in evaluating a metrics filter. The operator
         *        must have at least two predicates, and an object must match all of the predicates in order for the
         *        filter to apply.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder and(MetricsAndOperator and);
    }

    static final class BuilderImpl implements Builder {
        private String prefix;

        private Tag tag;

        private MetricsAndOperator and;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricsFilter model) {
            prefix(model.prefix);
            tag(model.tag);
            and(model.and);
        }

        public final String getPrefix() {
            return prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final Tag.Builder getTag() {
            return tag != null ? tag.toBuilder() : null;
        }

        @Override
        public final Builder tag(Tag tag) {
            this.tag = tag;
            return this;
        }

        public final void setTag(Tag.BuilderImpl tag) {
            this.tag = tag != null ? tag.build() : null;
        }

        public final MetricsAndOperator.Builder getAnd() {
            return and != null ? and.toBuilder() : null;
        }

        @Override
        public final Builder and(MetricsAndOperator and) {
            this.and = and;
            return this;
        }

        public final void setAnd(MetricsAndOperator.BuilderImpl and) {
            this.and = and != null ? and.build() : null;
        }

        @Override
        public MetricsFilter build() {
            return new MetricsFilter(this);
        }
    }
}
