/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class InventoryConfiguration implements ToCopyableBuilder<InventoryConfiguration.Builder, InventoryConfiguration> {
    private final InventoryDestination destination;

    private final Boolean isEnabled;

    private final InventoryFilter filter;

    private final String id;

    private final String includedObjectVersions;

    private final List<String> optionalFields;

    private final InventorySchedule schedule;

    private InventoryConfiguration(BuilderImpl builder) {
        this.destination = builder.destination;
        this.isEnabled = builder.isEnabled;
        this.filter = builder.filter;
        this.id = builder.id;
        this.includedObjectVersions = builder.includedObjectVersions;
        this.optionalFields = builder.optionalFields;
        this.schedule = builder.schedule;
    }

    /**
     * Contains information about where to publish the inventory results.
     * 
     * @return Contains information about where to publish the inventory results.
     */
    public InventoryDestination destination() {
        return destination;
    }

    /**
     * Specifies whether the inventory is enabled or disabled.
     * 
     * @return Specifies whether the inventory is enabled or disabled.
     */
    public Boolean isEnabled() {
        return isEnabled;
    }

    /**
     * Specifies an inventory filter. The inventory only includes objects that meet the filter's criteria.
     * 
     * @return Specifies an inventory filter. The inventory only includes objects that meet the filter's criteria.
     */
    public InventoryFilter filter() {
        return filter;
    }

    /**
     * The ID used to identify the inventory configuration.
     * 
     * @return The ID used to identify the inventory configuration.
     */
    public String id() {
        return id;
    }

    /**
     * Specifies which object version(s) to included in the inventory results.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #includedObjectVersions} will return {@link InventoryIncludedObjectVersions#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #includedObjectVersionsString}.
     * </p>
     * 
     * @return Specifies which object version(s) to included in the inventory results.
     * @see InventoryIncludedObjectVersions
     */
    public InventoryIncludedObjectVersions includedObjectVersions() {
        return InventoryIncludedObjectVersions.fromValue(includedObjectVersions);
    }

    /**
     * Specifies which object version(s) to included in the inventory results.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #includedObjectVersions} will return {@link InventoryIncludedObjectVersions#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #includedObjectVersionsString}.
     * </p>
     * 
     * @return Specifies which object version(s) to included in the inventory results.
     * @see InventoryIncludedObjectVersions
     */
    public String includedObjectVersionsString() {
        return includedObjectVersions;
    }

    /**
     * Contains the optional fields that are included in the inventory results.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Contains the optional fields that are included in the inventory results.
     */
    public List<InventoryOptionalField> optionalFields() {
        return TypeConverter.convert(optionalFields, InventoryOptionalField::fromValue);
    }

    /**
     * Contains the optional fields that are included in the inventory results.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Contains the optional fields that are included in the inventory results.
     */
    public List<String> optionalFieldsStrings() {
        return optionalFields;
    }

    /**
     * Specifies the schedule for generating inventory results.
     * 
     * @return Specifies the schedule for generating inventory results.
     */
    public InventorySchedule schedule() {
        return schedule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((destination() == null) ? 0 : destination().hashCode());
        hashCode = 31 * hashCode + ((isEnabled() == null) ? 0 : isEnabled().hashCode());
        hashCode = 31 * hashCode + ((filter() == null) ? 0 : filter().hashCode());
        hashCode = 31 * hashCode + ((id() == null) ? 0 : id().hashCode());
        hashCode = 31 * hashCode + ((includedObjectVersionsString() == null) ? 0 : includedObjectVersionsString().hashCode());
        hashCode = 31 * hashCode + ((optionalFieldsStrings() == null) ? 0 : optionalFieldsStrings().hashCode());
        hashCode = 31 * hashCode + ((schedule() == null) ? 0 : schedule().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InventoryConfiguration)) {
            return false;
        }
        InventoryConfiguration other = (InventoryConfiguration) obj;
        if (other.destination() == null ^ this.destination() == null) {
            return false;
        }
        if (other.destination() != null && !other.destination().equals(this.destination())) {
            return false;
        }
        if (other.isEnabled() == null ^ this.isEnabled() == null) {
            return false;
        }
        if (other.isEnabled() != null && !other.isEnabled().equals(this.isEnabled())) {
            return false;
        }
        if (other.filter() == null ^ this.filter() == null) {
            return false;
        }
        if (other.filter() != null && !other.filter().equals(this.filter())) {
            return false;
        }
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.includedObjectVersionsString() == null ^ this.includedObjectVersionsString() == null) {
            return false;
        }
        if (other.includedObjectVersionsString() != null
                && !other.includedObjectVersionsString().equals(this.includedObjectVersionsString())) {
            return false;
        }
        if (other.optionalFieldsStrings() == null ^ this.optionalFieldsStrings() == null) {
            return false;
        }
        if (other.optionalFieldsStrings() != null && !other.optionalFieldsStrings().equals(this.optionalFieldsStrings())) {
            return false;
        }
        if (other.schedule() == null ^ this.schedule() == null) {
            return false;
        }
        if (other.schedule() != null && !other.schedule().equals(this.schedule())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (destination() != null) {
            sb.append("Destination: ").append(destination()).append(",");
        }
        if (isEnabled() != null) {
            sb.append("IsEnabled: ").append(isEnabled()).append(",");
        }
        if (filter() != null) {
            sb.append("Filter: ").append(filter()).append(",");
        }
        if (id() != null) {
            sb.append("Id: ").append(id()).append(",");
        }
        if (includedObjectVersionsString() != null) {
            sb.append("IncludedObjectVersions: ").append(includedObjectVersionsString()).append(",");
        }
        if (optionalFieldsStrings() != null) {
            sb.append("OptionalFields: ").append(optionalFieldsStrings()).append(",");
        }
        if (schedule() != null) {
            sb.append("Schedule: ").append(schedule()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Destination":
            return Optional.of(clazz.cast(destination()));
        case "IsEnabled":
            return Optional.of(clazz.cast(isEnabled()));
        case "Filter":
            return Optional.of(clazz.cast(filter()));
        case "Id":
            return Optional.of(clazz.cast(id()));
        case "IncludedObjectVersions":
            return Optional.of(clazz.cast(includedObjectVersionsString()));
        case "OptionalFields":
            return Optional.of(clazz.cast(optionalFieldsStrings()));
        case "Schedule":
            return Optional.of(clazz.cast(schedule()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, InventoryConfiguration> {
        /**
         * Contains information about where to publish the inventory results.
         * 
         * @param destination
         *        Contains information about where to publish the inventory results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(InventoryDestination destination);

        /**
         * Specifies whether the inventory is enabled or disabled.
         * 
         * @param isEnabled
         *        Specifies whether the inventory is enabled or disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isEnabled(Boolean isEnabled);

        /**
         * Specifies an inventory filter. The inventory only includes objects that meet the filter's criteria.
         * 
         * @param filter
         *        Specifies an inventory filter. The inventory only includes objects that meet the filter's criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(InventoryFilter filter);

        /**
         * The ID used to identify the inventory configuration.
         * 
         * @param id
         *        The ID used to identify the inventory configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * Specifies which object version(s) to included in the inventory results.
         * 
         * @param includedObjectVersions
         *        Specifies which object version(s) to included in the inventory results.
         * @see InventoryIncludedObjectVersions
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InventoryIncludedObjectVersions
         */
        Builder includedObjectVersions(String includedObjectVersions);

        /**
         * Specifies which object version(s) to included in the inventory results.
         * 
         * @param includedObjectVersions
         *        Specifies which object version(s) to included in the inventory results.
         * @see InventoryIncludedObjectVersions
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InventoryIncludedObjectVersions
         */
        Builder includedObjectVersions(InventoryIncludedObjectVersions includedObjectVersions);

        /**
         * Contains the optional fields that are included in the inventory results.
         * 
         * @param optionalFields
         *        Contains the optional fields that are included in the inventory results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionalFields(Collection<String> optionalFields);

        /**
         * Contains the optional fields that are included in the inventory results.
         * 
         * @param optionalFields
         *        Contains the optional fields that are included in the inventory results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionalFields(String... optionalFields);

        /**
         * Specifies the schedule for generating inventory results.
         * 
         * @param schedule
         *        Specifies the schedule for generating inventory results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedule(InventorySchedule schedule);
    }

    static final class BuilderImpl implements Builder {
        private InventoryDestination destination;

        private Boolean isEnabled;

        private InventoryFilter filter;

        private String id;

        private String includedObjectVersions;

        private List<String> optionalFields;

        private InventorySchedule schedule;

        private BuilderImpl() {
        }

        private BuilderImpl(InventoryConfiguration model) {
            destination(model.destination);
            isEnabled(model.isEnabled);
            filter(model.filter);
            id(model.id);
            includedObjectVersions(model.includedObjectVersions);
            optionalFields(model.optionalFields);
            schedule(model.schedule);
        }

        public final InventoryDestination.Builder getDestination() {
            return destination != null ? destination.toBuilder() : null;
        }

        @Override
        public final Builder destination(InventoryDestination destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(InventoryDestination.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        public final Boolean getIsEnabled() {
            return isEnabled;
        }

        @Override
        public final Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            return this;
        }

        public final void setIsEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
        }

        public final InventoryFilter.Builder getFilter() {
            return filter != null ? filter.toBuilder() : null;
        }

        @Override
        public final Builder filter(InventoryFilter filter) {
            this.filter = filter;
            return this;
        }

        public final void setFilter(InventoryFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getIncludedObjectVersions() {
            return includedObjectVersions;
        }

        @Override
        public final Builder includedObjectVersions(String includedObjectVersions) {
            this.includedObjectVersions = includedObjectVersions;
            return this;
        }

        @Override
        public final Builder includedObjectVersions(InventoryIncludedObjectVersions includedObjectVersions) {
            this.includedObjectVersions(includedObjectVersions.toString());
            return this;
        }

        public final void setIncludedObjectVersions(String includedObjectVersions) {
            this.includedObjectVersions = includedObjectVersions;
        }

        public final Collection<String> getOptionalFields() {
            return optionalFields;
        }

        @Override
        public final Builder optionalFields(Collection<String> optionalFields) {
            this.optionalFields = InventoryOptionalFieldsCopier.copy(optionalFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionalFields(String... optionalFields) {
            optionalFields(Arrays.asList(optionalFields));
            return this;
        }

        public final void setOptionalFields(Collection<String> optionalFields) {
            this.optionalFields = InventoryOptionalFieldsCopier.copy(optionalFields);
        }

        public final InventorySchedule.Builder getSchedule() {
            return schedule != null ? schedule.toBuilder() : null;
        }

        @Override
        public final Builder schedule(InventorySchedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public final void setSchedule(InventorySchedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        @Override
        public InventoryConfiguration build() {
            return new InventoryConfiguration(this);
        }
    }
}
