/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetBucketWebsiteResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetBucketWebsiteResponse.Builder, GetBucketWebsiteResponse> {
    private final RedirectAllRequestsTo redirectAllRequestsTo;

    private final IndexDocument indexDocument;

    private final ErrorDocument errorDocument;

    private final List<RoutingRule> routingRules;

    private GetBucketWebsiteResponse(BuilderImpl builder) {
        this.redirectAllRequestsTo = builder.redirectAllRequestsTo;
        this.indexDocument = builder.indexDocument;
        this.errorDocument = builder.errorDocument;
        this.routingRules = builder.routingRules;
    }

    /**
     * Returns the value of the RedirectAllRequestsTo property for this object.
     * 
     * @return The value of the RedirectAllRequestsTo property for this object.
     */
    public RedirectAllRequestsTo redirectAllRequestsTo() {
        return redirectAllRequestsTo;
    }

    /**
     * Returns the value of the IndexDocument property for this object.
     * 
     * @return The value of the IndexDocument property for this object.
     */
    public IndexDocument indexDocument() {
        return indexDocument;
    }

    /**
     * Returns the value of the ErrorDocument property for this object.
     * 
     * @return The value of the ErrorDocument property for this object.
     */
    public ErrorDocument errorDocument() {
        return errorDocument;
    }

    /**
     * Returns the value of the RoutingRules property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the RoutingRules property for this object.
     */
    public List<RoutingRule> routingRules() {
        return routingRules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((redirectAllRequestsTo() == null) ? 0 : redirectAllRequestsTo().hashCode());
        hashCode = 31 * hashCode + ((indexDocument() == null) ? 0 : indexDocument().hashCode());
        hashCode = 31 * hashCode + ((errorDocument() == null) ? 0 : errorDocument().hashCode());
        hashCode = 31 * hashCode + ((routingRules() == null) ? 0 : routingRules().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBucketWebsiteResponse)) {
            return false;
        }
        GetBucketWebsiteResponse other = (GetBucketWebsiteResponse) obj;
        if (other.redirectAllRequestsTo() == null ^ this.redirectAllRequestsTo() == null) {
            return false;
        }
        if (other.redirectAllRequestsTo() != null && !other.redirectAllRequestsTo().equals(this.redirectAllRequestsTo())) {
            return false;
        }
        if (other.indexDocument() == null ^ this.indexDocument() == null) {
            return false;
        }
        if (other.indexDocument() != null && !other.indexDocument().equals(this.indexDocument())) {
            return false;
        }
        if (other.errorDocument() == null ^ this.errorDocument() == null) {
            return false;
        }
        if (other.errorDocument() != null && !other.errorDocument().equals(this.errorDocument())) {
            return false;
        }
        if (other.routingRules() == null ^ this.routingRules() == null) {
            return false;
        }
        if (other.routingRules() != null && !other.routingRules().equals(this.routingRules())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (redirectAllRequestsTo() != null) {
            sb.append("RedirectAllRequestsTo: ").append(redirectAllRequestsTo()).append(",");
        }
        if (indexDocument() != null) {
            sb.append("IndexDocument: ").append(indexDocument()).append(",");
        }
        if (errorDocument() != null) {
            sb.append("ErrorDocument: ").append(errorDocument()).append(",");
        }
        if (routingRules() != null) {
            sb.append("RoutingRules: ").append(routingRules()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RedirectAllRequestsTo":
            return Optional.of(clazz.cast(redirectAllRequestsTo()));
        case "IndexDocument":
            return Optional.of(clazz.cast(indexDocument()));
        case "ErrorDocument":
            return Optional.of(clazz.cast(errorDocument()));
        case "RoutingRules":
            return Optional.of(clazz.cast(routingRules()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GetBucketWebsiteResponse> {
        /**
         * Sets the value of the RedirectAllRequestsTo property for this object.
         *
         * @param redirectAllRequestsTo
         *        The new value for the RedirectAllRequestsTo property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redirectAllRequestsTo(RedirectAllRequestsTo redirectAllRequestsTo);

        /**
         * Sets the value of the IndexDocument property for this object.
         *
         * @param indexDocument
         *        The new value for the IndexDocument property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexDocument(IndexDocument indexDocument);

        /**
         * Sets the value of the ErrorDocument property for this object.
         *
         * @param errorDocument
         *        The new value for the ErrorDocument property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorDocument(ErrorDocument errorDocument);

        /**
         * Sets the value of the RoutingRules property for this object.
         *
         * @param routingRules
         *        The new value for the RoutingRules property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingRules(Collection<RoutingRule> routingRules);

        /**
         * Sets the value of the RoutingRules property for this object.
         *
         * @param routingRules
         *        The new value for the RoutingRules property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingRules(RoutingRule... routingRules);
    }

    static final class BuilderImpl implements Builder {
        private RedirectAllRequestsTo redirectAllRequestsTo;

        private IndexDocument indexDocument;

        private ErrorDocument errorDocument;

        private List<RoutingRule> routingRules;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBucketWebsiteResponse model) {
            redirectAllRequestsTo(model.redirectAllRequestsTo);
            indexDocument(model.indexDocument);
            errorDocument(model.errorDocument);
            routingRules(model.routingRules);
        }

        public final RedirectAllRequestsTo.Builder getRedirectAllRequestsTo() {
            return redirectAllRequestsTo != null ? redirectAllRequestsTo.toBuilder() : null;
        }

        @Override
        public final Builder redirectAllRequestsTo(RedirectAllRequestsTo redirectAllRequestsTo) {
            this.redirectAllRequestsTo = redirectAllRequestsTo;
            return this;
        }

        public final void setRedirectAllRequestsTo(RedirectAllRequestsTo.BuilderImpl redirectAllRequestsTo) {
            this.redirectAllRequestsTo = redirectAllRequestsTo != null ? redirectAllRequestsTo.build() : null;
        }

        public final IndexDocument.Builder getIndexDocument() {
            return indexDocument != null ? indexDocument.toBuilder() : null;
        }

        @Override
        public final Builder indexDocument(IndexDocument indexDocument) {
            this.indexDocument = indexDocument;
            return this;
        }

        public final void setIndexDocument(IndexDocument.BuilderImpl indexDocument) {
            this.indexDocument = indexDocument != null ? indexDocument.build() : null;
        }

        public final ErrorDocument.Builder getErrorDocument() {
            return errorDocument != null ? errorDocument.toBuilder() : null;
        }

        @Override
        public final Builder errorDocument(ErrorDocument errorDocument) {
            this.errorDocument = errorDocument;
            return this;
        }

        public final void setErrorDocument(ErrorDocument.BuilderImpl errorDocument) {
            this.errorDocument = errorDocument != null ? errorDocument.build() : null;
        }

        public final Collection<RoutingRule.Builder> getRoutingRules() {
            return routingRules != null ? routingRules.stream().map(RoutingRule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder routingRules(Collection<RoutingRule> routingRules) {
            this.routingRules = RoutingRulesCopier.copy(routingRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingRules(RoutingRule... routingRules) {
            routingRules(Arrays.asList(routingRules));
            return this;
        }

        public final void setRoutingRules(Collection<RoutingRule.BuilderImpl> routingRules) {
            this.routingRules = RoutingRulesCopier.copyFromBuilder(routingRules);
        }

        @Override
        public GetBucketWebsiteResponse build() {
            return new GetBucketWebsiteResponse(this);
        }
    }
}
