/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Container for specifying the notification configuration of the bucket. If this element is empty, notifications are
 * turned off on the bucket.
 */
@Generated("software.amazon.awssdk:codegen")
public class GetBucketNotificationConfigurationResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetBucketNotificationConfigurationResponse.Builder, GetBucketNotificationConfigurationResponse> {
    private final List<TopicConfiguration> topicConfigurations;

    private final List<QueueConfiguration> queueConfigurations;

    private final List<LambdaFunctionConfiguration> lambdaFunctionConfigurations;

    private GetBucketNotificationConfigurationResponse(BuilderImpl builder) {
        this.topicConfigurations = builder.topicConfigurations;
        this.queueConfigurations = builder.queueConfigurations;
        this.lambdaFunctionConfigurations = builder.lambdaFunctionConfigurations;
    }

    /**
     * Returns the value of the TopicConfigurations property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the TopicConfigurations property for this object.
     */
    public List<TopicConfiguration> topicConfigurations() {
        return topicConfigurations;
    }

    /**
     * Returns the value of the QueueConfigurations property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the QueueConfigurations property for this object.
     */
    public List<QueueConfiguration> queueConfigurations() {
        return queueConfigurations;
    }

    /**
     * Returns the value of the LambdaFunctionConfigurations property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the LambdaFunctionConfigurations property for this object.
     */
    public List<LambdaFunctionConfiguration> lambdaFunctionConfigurations() {
        return lambdaFunctionConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((topicConfigurations() == null) ? 0 : topicConfigurations().hashCode());
        hashCode = 31 * hashCode + ((queueConfigurations() == null) ? 0 : queueConfigurations().hashCode());
        hashCode = 31 * hashCode + ((lambdaFunctionConfigurations() == null) ? 0 : lambdaFunctionConfigurations().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBucketNotificationConfigurationResponse)) {
            return false;
        }
        GetBucketNotificationConfigurationResponse other = (GetBucketNotificationConfigurationResponse) obj;
        if (other.topicConfigurations() == null ^ this.topicConfigurations() == null) {
            return false;
        }
        if (other.topicConfigurations() != null && !other.topicConfigurations().equals(this.topicConfigurations())) {
            return false;
        }
        if (other.queueConfigurations() == null ^ this.queueConfigurations() == null) {
            return false;
        }
        if (other.queueConfigurations() != null && !other.queueConfigurations().equals(this.queueConfigurations())) {
            return false;
        }
        if (other.lambdaFunctionConfigurations() == null ^ this.lambdaFunctionConfigurations() == null) {
            return false;
        }
        if (other.lambdaFunctionConfigurations() != null
                && !other.lambdaFunctionConfigurations().equals(this.lambdaFunctionConfigurations())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (topicConfigurations() != null) {
            sb.append("TopicConfigurations: ").append(topicConfigurations()).append(",");
        }
        if (queueConfigurations() != null) {
            sb.append("QueueConfigurations: ").append(queueConfigurations()).append(",");
        }
        if (lambdaFunctionConfigurations() != null) {
            sb.append("LambdaFunctionConfigurations: ").append(lambdaFunctionConfigurations()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TopicConfigurations":
            return Optional.of(clazz.cast(topicConfigurations()));
        case "QueueConfigurations":
            return Optional.of(clazz.cast(queueConfigurations()));
        case "LambdaFunctionConfigurations":
            return Optional.of(clazz.cast(lambdaFunctionConfigurations()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GetBucketNotificationConfigurationResponse> {
        /**
         * Sets the value of the TopicConfigurations property for this object.
         *
         * @param topicConfigurations
         *        The new value for the TopicConfigurations property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicConfigurations(Collection<TopicConfiguration> topicConfigurations);

        /**
         * Sets the value of the TopicConfigurations property for this object.
         *
         * @param topicConfigurations
         *        The new value for the TopicConfigurations property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicConfigurations(TopicConfiguration... topicConfigurations);

        /**
         * Sets the value of the QueueConfigurations property for this object.
         *
         * @param queueConfigurations
         *        The new value for the QueueConfigurations property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueConfigurations(Collection<QueueConfiguration> queueConfigurations);

        /**
         * Sets the value of the QueueConfigurations property for this object.
         *
         * @param queueConfigurations
         *        The new value for the QueueConfigurations property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueConfigurations(QueueConfiguration... queueConfigurations);

        /**
         * Sets the value of the LambdaFunctionConfigurations property for this object.
         *
         * @param lambdaFunctionConfigurations
         *        The new value for the LambdaFunctionConfigurations property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaFunctionConfigurations(Collection<LambdaFunctionConfiguration> lambdaFunctionConfigurations);

        /**
         * Sets the value of the LambdaFunctionConfigurations property for this object.
         *
         * @param lambdaFunctionConfigurations
         *        The new value for the LambdaFunctionConfigurations property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaFunctionConfigurations(LambdaFunctionConfiguration... lambdaFunctionConfigurations);
    }

    static final class BuilderImpl implements Builder {
        private List<TopicConfiguration> topicConfigurations;

        private List<QueueConfiguration> queueConfigurations;

        private List<LambdaFunctionConfiguration> lambdaFunctionConfigurations;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBucketNotificationConfigurationResponse model) {
            topicConfigurations(model.topicConfigurations);
            queueConfigurations(model.queueConfigurations);
            lambdaFunctionConfigurations(model.lambdaFunctionConfigurations);
        }

        public final Collection<TopicConfiguration.Builder> getTopicConfigurations() {
            return topicConfigurations != null ? topicConfigurations.stream().map(TopicConfiguration::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder topicConfigurations(Collection<TopicConfiguration> topicConfigurations) {
            this.topicConfigurations = TopicConfigurationListCopier.copy(topicConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topicConfigurations(TopicConfiguration... topicConfigurations) {
            topicConfigurations(Arrays.asList(topicConfigurations));
            return this;
        }

        public final void setTopicConfigurations(Collection<TopicConfiguration.BuilderImpl> topicConfigurations) {
            this.topicConfigurations = TopicConfigurationListCopier.copyFromBuilder(topicConfigurations);
        }

        public final Collection<QueueConfiguration.Builder> getQueueConfigurations() {
            return queueConfigurations != null ? queueConfigurations.stream().map(QueueConfiguration::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder queueConfigurations(Collection<QueueConfiguration> queueConfigurations) {
            this.queueConfigurations = QueueConfigurationListCopier.copy(queueConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queueConfigurations(QueueConfiguration... queueConfigurations) {
            queueConfigurations(Arrays.asList(queueConfigurations));
            return this;
        }

        public final void setQueueConfigurations(Collection<QueueConfiguration.BuilderImpl> queueConfigurations) {
            this.queueConfigurations = QueueConfigurationListCopier.copyFromBuilder(queueConfigurations);
        }

        public final Collection<LambdaFunctionConfiguration.Builder> getLambdaFunctionConfigurations() {
            return lambdaFunctionConfigurations != null ? lambdaFunctionConfigurations.stream()
                    .map(LambdaFunctionConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder lambdaFunctionConfigurations(Collection<LambdaFunctionConfiguration> lambdaFunctionConfigurations) {
            this.lambdaFunctionConfigurations = LambdaFunctionConfigurationListCopier.copy(lambdaFunctionConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lambdaFunctionConfigurations(LambdaFunctionConfiguration... lambdaFunctionConfigurations) {
            lambdaFunctionConfigurations(Arrays.asList(lambdaFunctionConfigurations));
            return this;
        }

        public final void setLambdaFunctionConfigurations(
                Collection<LambdaFunctionConfiguration.BuilderImpl> lambdaFunctionConfigurations) {
            this.lambdaFunctionConfigurations = LambdaFunctionConfigurationListCopier
                    .copyFromBuilder(lambdaFunctionConfigurations);
        }

        @Override
        public GetBucketNotificationConfigurationResponse build() {
            return new GetBucketNotificationConfigurationResponse(this);
        }
    }
}
