/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateBucketConfiguration implements ToCopyableBuilder<CreateBucketConfiguration.Builder, CreateBucketConfiguration> {
    private final String locationConstraint;

    private CreateBucketConfiguration(BuilderImpl builder) {
        this.locationConstraint = builder.locationConstraint;
    }

    /**
     * Specifies the region where the bucket will be created. If you don't specify a region, the bucket will be created
     * in US Standard.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #locationConstraint} will return {@link BucketLocationConstraint#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #locationConstraintString}.
     * </p>
     * 
     * @return Specifies the region where the bucket will be created. If you don't specify a region, the bucket will be
     *         created in US Standard.
     * @see BucketLocationConstraint
     */
    public BucketLocationConstraint locationConstraint() {
        return BucketLocationConstraint.fromValue(locationConstraint);
    }

    /**
     * Specifies the region where the bucket will be created. If you don't specify a region, the bucket will be created
     * in US Standard.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #locationConstraint} will return {@link BucketLocationConstraint#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #locationConstraintString}.
     * </p>
     * 
     * @return Specifies the region where the bucket will be created. If you don't specify a region, the bucket will be
     *         created in US Standard.
     * @see BucketLocationConstraint
     */
    public String locationConstraintString() {
        return locationConstraint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((locationConstraintString() == null) ? 0 : locationConstraintString().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBucketConfiguration)) {
            return false;
        }
        CreateBucketConfiguration other = (CreateBucketConfiguration) obj;
        if (other.locationConstraintString() == null ^ this.locationConstraintString() == null) {
            return false;
        }
        if (other.locationConstraintString() != null && !other.locationConstraintString().equals(this.locationConstraintString())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (locationConstraintString() != null) {
            sb.append("LocationConstraint: ").append(locationConstraintString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LocationConstraint":
            return Optional.of(clazz.cast(locationConstraintString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CreateBucketConfiguration> {
        /**
         * Specifies the region where the bucket will be created. If you don't specify a region, the bucket will be
         * created in US Standard.
         * 
         * @param locationConstraint
         *        Specifies the region where the bucket will be created. If you don't specify a region, the bucket will
         *        be created in US Standard.
         * @see BucketLocationConstraint
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BucketLocationConstraint
         */
        Builder locationConstraint(String locationConstraint);

        /**
         * Specifies the region where the bucket will be created. If you don't specify a region, the bucket will be
         * created in US Standard.
         * 
         * @param locationConstraint
         *        Specifies the region where the bucket will be created. If you don't specify a region, the bucket will
         *        be created in US Standard.
         * @see BucketLocationConstraint
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BucketLocationConstraint
         */
        Builder locationConstraint(BucketLocationConstraint locationConstraint);
    }

    static final class BuilderImpl implements Builder {
        private String locationConstraint;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBucketConfiguration model) {
            locationConstraint(model.locationConstraint);
        }

        public final String getLocationConstraint() {
            return locationConstraint;
        }

        @Override
        public final Builder locationConstraint(String locationConstraint) {
            this.locationConstraint = locationConstraint;
            return this;
        }

        @Override
        public final Builder locationConstraint(BucketLocationConstraint locationConstraint) {
            this.locationConstraint(locationConstraint.toString());
            return this;
        }

        public final void setLocationConstraint(String locationConstraint) {
            this.locationConstraint = locationConstraint;
        }

        @Override
        public CreateBucketConfiguration build() {
            return new CreateBucketConfiguration(this);
        }
    }
}
