/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class AnalyticsExportDestination implements
        ToCopyableBuilder<AnalyticsExportDestination.Builder, AnalyticsExportDestination> {
    private final AnalyticsS3BucketDestination s3BucketDestination;

    private AnalyticsExportDestination(BuilderImpl builder) {
        this.s3BucketDestination = builder.s3BucketDestination;
    }

    /**
     * A destination signifying output to an S3 bucket.
     * 
     * @return A destination signifying output to an S3 bucket.
     */
    public AnalyticsS3BucketDestination s3BucketDestination() {
        return s3BucketDestination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((s3BucketDestination() == null) ? 0 : s3BucketDestination().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalyticsExportDestination)) {
            return false;
        }
        AnalyticsExportDestination other = (AnalyticsExportDestination) obj;
        if (other.s3BucketDestination() == null ^ this.s3BucketDestination() == null) {
            return false;
        }
        if (other.s3BucketDestination() != null && !other.s3BucketDestination().equals(this.s3BucketDestination())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (s3BucketDestination() != null) {
            sb.append("S3BucketDestination: ").append(s3BucketDestination()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3BucketDestination":
            return Optional.of(clazz.cast(s3BucketDestination()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, AnalyticsExportDestination> {
        /**
         * A destination signifying output to an S3 bucket.
         * 
         * @param s3BucketDestination
         *        A destination signifying output to an S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketDestination(AnalyticsS3BucketDestination s3BucketDestination);
    }

    static final class BuilderImpl implements Builder {
        private AnalyticsS3BucketDestination s3BucketDestination;

        private BuilderImpl() {
        }

        private BuilderImpl(AnalyticsExportDestination model) {
            s3BucketDestination(model.s3BucketDestination);
        }

        public final AnalyticsS3BucketDestination.Builder getS3BucketDestination() {
            return s3BucketDestination != null ? s3BucketDestination.toBuilder() : null;
        }

        @Override
        public final Builder s3BucketDestination(AnalyticsS3BucketDestination s3BucketDestination) {
            this.s3BucketDestination = s3BucketDestination;
            return this;
        }

        public final void setS3BucketDestination(AnalyticsS3BucketDestination.BuilderImpl s3BucketDestination) {
            this.s3BucketDestination = s3BucketDestination != null ? s3BucketDestination.build() : null;
        }

        @Override
        public AnalyticsExportDestination build() {
            return new AnalyticsExportDestination(this);
        }
    }
}
