/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3;

import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.auth.StaticSignerProvider;
import software.amazon.awssdk.core.client.builder.DefaultClientBuilder;
import software.amazon.awssdk.core.config.defaults.ClientConfigurationDefaults;
import software.amazon.awssdk.core.config.defaults.ServiceBuilderConfigurationDefaults;
import software.amazon.awssdk.core.runtime.auth.SignerProvider;

/**
 * Internal base class for {@link DefaultS3ClientBuilder} and {@link DefaultS3AsyncClientBuilder}.
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
abstract class DefaultS3BaseClientBuilder<B extends S3BaseClientBuilder<B, C>, C> extends DefaultClientBuilder<B, C> {
    private S3AdvancedConfiguration advancedConfiguration;

    @Override
    protected final String serviceEndpointPrefix() {
        return "s3";
    }

    @Override
    protected final ClientConfigurationDefaults serviceDefaults() {
        return ServiceBuilderConfigurationDefaults.builder().defaultSignerProvider(this::defaultSignerProvider)
                .addRequestHandlerPath("software/amazon/awssdk/services/s3/execution.interceptors")
                .crc32FromCompressedDataEnabled(false).build();
    }

    private SignerProvider defaultSignerProvider() {
        AwsS3V4Signer signer = new AwsS3V4Signer();
        signer.setServiceName("s3");
        signer.setRegionName(signingRegion().value());
        return new StaticSignerProvider(signer);
    }

    public B advancedConfiguration(S3AdvancedConfiguration advancedConfiguration) {
        this.advancedConfiguration = advancedConfiguration;
        return thisBuilder();
    }

    protected S3AdvancedConfiguration advancedConfiguration() {
        return advancedConfiguration;
    }

    public void setAdvancedConfiguration(S3AdvancedConfiguration advancedConfiguration) {
        advancedConfiguration(advancedConfiguration);
    }
}
