/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.services.s3.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * UploadPartResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class UploadPartResponseUnmarshaller implements Unmarshaller<UploadPartResponse, StaxUnmarshallerContext> {

    public UploadPartResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        UploadPartResponse.Builder uploadPartResponse = UploadPartResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        if (context.isStartOfDocument()) {
            context.setCurrentHeader("x-amz-server-side-encryption");
            uploadPartResponse.serverSideEncryption(StringUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("ETag");
            uploadPartResponse.eTag(StringUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("x-amz-server-side-encryption-customer-algorithm");
            uploadPartResponse.sseCustomerAlgorithm(StringUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("x-amz-server-side-encryption-customer-key-MD5");
            uploadPartResponse.sseCustomerKeyMD5(StringUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("x-amz-server-side-encryption-aws-kms-key-id");
            uploadPartResponse.ssekmsKeyId(StringUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("x-amz-request-charged");
            uploadPartResponse.requestCharged(StringUnmarshaller.getInstance().unmarshall(context));

        }

        return uploadPartResponse.build();
    }

    private static final UploadPartResponseUnmarshaller INSTANCE = new UploadPartResponseUnmarshaller();

    public static UploadPartResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
