/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.services.s3.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * PutObjectResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class PutObjectResponseUnmarshaller implements Unmarshaller<PutObjectResponse, StaxUnmarshallerContext> {

    public PutObjectResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        PutObjectResponse.Builder putObjectResponse = PutObjectResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        if (context.isStartOfDocument()) {
            context.setCurrentHeader("x-amz-expiration");
            putObjectResponse.expiration(StringUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("ETag");
            putObjectResponse.eTag(StringUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("x-amz-server-side-encryption");
            putObjectResponse.serverSideEncryption(StringUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("x-amz-version-id");
            putObjectResponse.versionId(StringUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("x-amz-server-side-encryption-customer-algorithm");
            putObjectResponse.sseCustomerAlgorithm(StringUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("x-amz-server-side-encryption-customer-key-MD5");
            putObjectResponse.sseCustomerKeyMD5(StringUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("x-amz-server-side-encryption-aws-kms-key-id");
            putObjectResponse.ssekmsKeyId(StringUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("x-amz-request-charged");
            putObjectResponse.requestCharged(StringUnmarshaller.getInstance().unmarshall(context));

        }

        return putObjectResponse.build();
    }

    private static final PutObjectResponseUnmarshaller INSTANCE = new PutObjectResponseUnmarshaller();

    public static PutObjectResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
