/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.s3.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * NotificationConfiguration StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class NotificationConfigurationUnmarshaller implements Unmarshaller<NotificationConfiguration, StaxUnmarshallerContext> {

    public NotificationConfiguration unmarshall(StaxUnmarshallerContext context) throws Exception {
        NotificationConfiguration.Builder notificationConfiguration = NotificationConfiguration.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<TopicConfiguration> topicConfigurations = null;
        java.util.List<QueueConfiguration> queueConfigurations = null;
        java.util.List<LambdaFunctionConfiguration> lambdaFunctionConfigurations = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                notificationConfiguration.topicConfigurations(topicConfigurations);
                notificationConfiguration.queueConfigurations(queueConfigurations);
                notificationConfiguration.lambdaFunctionConfigurations(lambdaFunctionConfigurations);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("TopicConfiguration", targetDepth)) {
                    if (topicConfigurations == null) {
                        topicConfigurations = new ArrayList<>();
                    }
                    topicConfigurations.add(TopicConfigurationUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("QueueConfiguration", targetDepth)) {
                    if (queueConfigurations == null) {
                        queueConfigurations = new ArrayList<>();
                    }
                    queueConfigurations.add(QueueConfigurationUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("CloudFunctionConfiguration", targetDepth)) {
                    if (lambdaFunctionConfigurations == null) {
                        lambdaFunctionConfigurations = new ArrayList<>();
                    }
                    lambdaFunctionConfigurations.add(LambdaFunctionConfigurationUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    notificationConfiguration.topicConfigurations(topicConfigurations);
                    notificationConfiguration.queueConfigurations(queueConfigurations);
                    notificationConfiguration.lambdaFunctionConfigurations(lambdaFunctionConfigurations);
                    break;
                }
            }
        }
        return notificationConfiguration.build();
    }

    private static final NotificationConfigurationUnmarshaller INSTANCE = new NotificationConfigurationUnmarshaller();

    public static NotificationConfigurationUnmarshaller getInstance() {
        return INSTANCE;
    }
}
