/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.s3.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * ListObjectVersionsResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ListObjectVersionsResponseUnmarshaller implements Unmarshaller<ListObjectVersionsResponse, StaxUnmarshallerContext> {

    public ListObjectVersionsResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        ListObjectVersionsResponse.Builder listObjectVersionsResponse = ListObjectVersionsResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<ObjectVersion> versions = null;
        java.util.List<DeleteMarkerEntry> deleteMarkers = null;
        java.util.List<CommonPrefix> commonPrefixes = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                listObjectVersionsResponse.versions(versions);
                listObjectVersionsResponse.deleteMarkers(deleteMarkers);
                listObjectVersionsResponse.commonPrefixes(commonPrefixes);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("IsTruncated", targetDepth)) {
                    listObjectVersionsResponse.isTruncated(BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("KeyMarker", targetDepth)) {
                    listObjectVersionsResponse.keyMarker(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("VersionIdMarker", targetDepth)) {
                    listObjectVersionsResponse.versionIdMarker(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("NextKeyMarker", targetDepth)) {
                    listObjectVersionsResponse.nextKeyMarker(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("NextVersionIdMarker", targetDepth)) {
                    listObjectVersionsResponse.nextVersionIdMarker(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Version", targetDepth)) {
                    if (versions == null) {
                        versions = new ArrayList<>();
                    }
                    versions.add(ObjectVersionUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("DeleteMarker", targetDepth)) {
                    if (deleteMarkers == null) {
                        deleteMarkers = new ArrayList<>();
                    }
                    deleteMarkers.add(DeleteMarkerEntryUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Name", targetDepth)) {
                    listObjectVersionsResponse.name(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Prefix", targetDepth)) {
                    listObjectVersionsResponse.prefix(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Delimiter", targetDepth)) {
                    listObjectVersionsResponse.delimiter(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("MaxKeys", targetDepth)) {
                    listObjectVersionsResponse.maxKeys(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("CommonPrefixes", targetDepth)) {
                    if (commonPrefixes == null) {
                        commonPrefixes = new ArrayList<>();
                    }
                    commonPrefixes.add(CommonPrefixUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("EncodingType", targetDepth)) {
                    listObjectVersionsResponse.encodingType(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    listObjectVersionsResponse.versions(versions);
                    listObjectVersionsResponse.deleteMarkers(deleteMarkers);
                    listObjectVersionsResponse.commonPrefixes(commonPrefixes);
                    break;
                }
            }
        }
        return listObjectVersionsResponse.build();
    }

    private static final ListObjectVersionsResponseUnmarshaller INSTANCE = new ListObjectVersionsResponseUnmarshaller();

    public static ListObjectVersionsResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
