/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class StorageClassAnalysisDataExport implements
        ToCopyableBuilder<StorageClassAnalysisDataExport.Builder, StorageClassAnalysisDataExport> {
    private final String outputSchemaVersion;

    private final AnalyticsExportDestination destination;

    private StorageClassAnalysisDataExport(BuilderImpl builder) {
        this.outputSchemaVersion = builder.outputSchemaVersion;
        this.destination = builder.destination;
    }

    /**
     * The version of the output schema to use when exporting data. Must be V_1.
     * 
     * @return The version of the output schema to use when exporting data. Must be V_1.
     * @see StorageClassAnalysisSchemaVersion
     */
    public String outputSchemaVersion() {
        return outputSchemaVersion;
    }

    /**
     * The place to store the data for an analysis.
     * 
     * @return The place to store the data for an analysis.
     */
    public AnalyticsExportDestination destination() {
        return destination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((outputSchemaVersion() == null) ? 0 : outputSchemaVersion().hashCode());
        hashCode = 31 * hashCode + ((destination() == null) ? 0 : destination().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StorageClassAnalysisDataExport)) {
            return false;
        }
        StorageClassAnalysisDataExport other = (StorageClassAnalysisDataExport) obj;
        if (other.outputSchemaVersion() == null ^ this.outputSchemaVersion() == null) {
            return false;
        }
        if (other.outputSchemaVersion() != null && !other.outputSchemaVersion().equals(this.outputSchemaVersion())) {
            return false;
        }
        if (other.destination() == null ^ this.destination() == null) {
            return false;
        }
        if (other.destination() != null && !other.destination().equals(this.destination())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (outputSchemaVersion() != null) {
            sb.append("OutputSchemaVersion: ").append(outputSchemaVersion()).append(",");
        }
        if (destination() != null) {
            sb.append("Destination: ").append(destination()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, StorageClassAnalysisDataExport> {
        /**
         * The version of the output schema to use when exporting data. Must be V_1.
         * 
         * @param outputSchemaVersion
         *        The version of the output schema to use when exporting data. Must be V_1.
         * @see StorageClassAnalysisSchemaVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageClassAnalysisSchemaVersion
         */
        Builder outputSchemaVersion(String outputSchemaVersion);

        /**
         * The version of the output schema to use when exporting data. Must be V_1.
         * 
         * @param outputSchemaVersion
         *        The version of the output schema to use when exporting data. Must be V_1.
         * @see StorageClassAnalysisSchemaVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageClassAnalysisSchemaVersion
         */
        Builder outputSchemaVersion(StorageClassAnalysisSchemaVersion outputSchemaVersion);

        /**
         * The place to store the data for an analysis.
         * 
         * @param destination
         *        The place to store the data for an analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(AnalyticsExportDestination destination);
    }

    private static final class BuilderImpl implements Builder {
        private String outputSchemaVersion;

        private AnalyticsExportDestination destination;

        private BuilderImpl() {
        }

        private BuilderImpl(StorageClassAnalysisDataExport model) {
            setOutputSchemaVersion(model.outputSchemaVersion);
            setDestination(model.destination);
        }

        public final String getOutputSchemaVersion() {
            return outputSchemaVersion;
        }

        @Override
        public final Builder outputSchemaVersion(String outputSchemaVersion) {
            this.outputSchemaVersion = outputSchemaVersion;
            return this;
        }

        @Override
        public final Builder outputSchemaVersion(StorageClassAnalysisSchemaVersion outputSchemaVersion) {
            this.outputSchemaVersion(outputSchemaVersion.toString());
            return this;
        }

        public final void setOutputSchemaVersion(String outputSchemaVersion) {
            this.outputSchemaVersion = outputSchemaVersion;
        }

        public final AnalyticsExportDestination getDestination() {
            return destination;
        }

        @Override
        public final Builder destination(AnalyticsExportDestination destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(AnalyticsExportDestination destination) {
            this.destination = destination;
        }

        @Override
        public StorageClassAnalysisDataExport build() {
            return new StorageClassAnalysisDataExport(this);
        }
    }
}
