/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Container for object key name prefix and suffix filtering rules.
 */
@Generated("software.amazon.awssdk:codegen")
public class S3KeyFilter implements ToCopyableBuilder<S3KeyFilter.Builder, S3KeyFilter> {
    private final List<FilterRule> filterRules;

    private S3KeyFilter(BuilderImpl builder) {
        this.filterRules = builder.filterRules;
    }

    /**
     * Returns the value of the FilterRules property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the FilterRules property for this object.
     */
    public List<FilterRule> filterRules() {
        return filterRules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((filterRules() == null) ? 0 : filterRules().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3KeyFilter)) {
            return false;
        }
        S3KeyFilter other = (S3KeyFilter) obj;
        if (other.filterRules() == null ^ this.filterRules() == null) {
            return false;
        }
        if (other.filterRules() != null && !other.filterRules().equals(this.filterRules())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (filterRules() != null) {
            sb.append("FilterRules: ").append(filterRules()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, S3KeyFilter> {
        /**
         * Sets the value of the FilterRules property for this object.
         *
         * @param filterRules
         *        The new value for the FilterRules property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterRules(Collection<FilterRule> filterRules);

        /**
         * Sets the value of the FilterRules property for this object.
         *
         * @param filterRules
         *        The new value for the FilterRules property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterRules(FilterRule... filterRules);
    }

    private static final class BuilderImpl implements Builder {
        private List<FilterRule> filterRules;

        private BuilderImpl() {
        }

        private BuilderImpl(S3KeyFilter model) {
            setFilterRules(model.filterRules);
        }

        public final Collection<FilterRule> getFilterRules() {
            return filterRules;
        }

        @Override
        public final Builder filterRules(Collection<FilterRule> filterRules) {
            this.filterRules = FilterRuleListCopier.copy(filterRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterRules(FilterRule... filterRules) {
            filterRules(Arrays.asList(filterRules));
            return this;
        }

        public final void setFilterRules(Collection<FilterRule> filterRules) {
            this.filterRules = FilterRuleListCopier.copy(filterRules);
        }

        @Override
        public S3KeyFilter build() {
            return new S3KeyFilter(this);
        }
    }
}
