/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Container for replication rules. You can add as many as 1,000 rules. Total replication configuration size can be up
 * to 2 MB.
 */
@Generated("software.amazon.awssdk:codegen")
public class ReplicationConfiguration implements ToCopyableBuilder<ReplicationConfiguration.Builder, ReplicationConfiguration> {
    private final String role;

    private final List<ReplicationRule> rules;

    private ReplicationConfiguration(BuilderImpl builder) {
        this.role = builder.role;
        this.rules = builder.rules;
    }

    /**
     * Amazon Resource Name (ARN) of an IAM role for Amazon S3 to assume when replicating the objects.
     * 
     * @return Amazon Resource Name (ARN) of an IAM role for Amazon S3 to assume when replicating the objects.
     */
    public String role() {
        return role;
    }

    /**
     * Container for information about a particular replication rule. Replication configuration must have at least one
     * rule and can contain up to 1,000 rules.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Container for information about a particular replication rule. Replication configuration must have at
     *         least one rule and can contain up to 1,000 rules.
     */
    public List<ReplicationRule> rules() {
        return rules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((role() == null) ? 0 : role().hashCode());
        hashCode = 31 * hashCode + ((rules() == null) ? 0 : rules().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationConfiguration)) {
            return false;
        }
        ReplicationConfiguration other = (ReplicationConfiguration) obj;
        if (other.role() == null ^ this.role() == null) {
            return false;
        }
        if (other.role() != null && !other.role().equals(this.role())) {
            return false;
        }
        if (other.rules() == null ^ this.rules() == null) {
            return false;
        }
        if (other.rules() != null && !other.rules().equals(this.rules())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (role() != null) {
            sb.append("Role: ").append(role()).append(",");
        }
        if (rules() != null) {
            sb.append("Rules: ").append(rules()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ReplicationConfiguration> {
        /**
         * Amazon Resource Name (ARN) of an IAM role for Amazon S3 to assume when replicating the objects.
         * 
         * @param role
         *        Amazon Resource Name (ARN) of an IAM role for Amazon S3 to assume when replicating the objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder role(String role);

        /**
         * Container for information about a particular replication rule. Replication configuration must have at least
         * one rule and can contain up to 1,000 rules.
         * 
         * @param rules
         *        Container for information about a particular replication rule. Replication configuration must have at
         *        least one rule and can contain up to 1,000 rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Collection<ReplicationRule> rules);

        /**
         * Container for information about a particular replication rule. Replication configuration must have at least
         * one rule and can contain up to 1,000 rules.
         * 
         * @param rules
         *        Container for information about a particular replication rule. Replication configuration must have at
         *        least one rule and can contain up to 1,000 rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(ReplicationRule... rules);
    }

    private static final class BuilderImpl implements Builder {
        private String role;

        private List<ReplicationRule> rules;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationConfiguration model) {
            setRole(model.role);
            setRules(model.rules);
        }

        public final String getRole() {
            return role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        public final Collection<ReplicationRule> getRules() {
            return rules;
        }

        @Override
        public final Builder rules(Collection<ReplicationRule> rules) {
            this.rules = ReplicationRulesCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(ReplicationRule... rules) {
            rules(Arrays.asList(rules));
            return this;
        }

        public final void setRules(Collection<ReplicationRule> rules) {
            this.rules = ReplicationRulesCopier.copy(rules);
        }

        @Override
        public ReplicationConfiguration build() {
            return new ReplicationConfiguration(this);
        }
    }
}
