/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class PutBucketVersioningRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<PutBucketVersioningRequest.Builder, PutBucketVersioningRequest> {
    private final String bucket;

    private final String contentMD5;

    private final String mfa;

    private final VersioningConfiguration versioningConfiguration;

    private PutBucketVersioningRequest(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.contentMD5 = builder.contentMD5;
        this.mfa = builder.mfa;
        this.versioningConfiguration = builder.versioningConfiguration;
    }

    /**
     * Returns the value of the Bucket property for this object.
     * 
     * @return The value of the Bucket property for this object.
     */
    public String bucket() {
        return bucket;
    }

    /**
     * Returns the value of the ContentMD5 property for this object.
     * 
     * @return The value of the ContentMD5 property for this object.
     */
    public String contentMD5() {
        return contentMD5;
    }

    /**
     * The concatenation of the authentication device's serial number, a space, and the value that is displayed on your
     * authentication device.
     * 
     * @return The concatenation of the authentication device's serial number, a space, and the value that is displayed
     *         on your authentication device.
     */
    public String mfa() {
        return mfa;
    }

    /**
     * Returns the value of the VersioningConfiguration property for this object.
     * 
     * @return The value of the VersioningConfiguration property for this object.
     */
    public VersioningConfiguration versioningConfiguration() {
        return versioningConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((bucket() == null) ? 0 : bucket().hashCode());
        hashCode = 31 * hashCode + ((contentMD5() == null) ? 0 : contentMD5().hashCode());
        hashCode = 31 * hashCode + ((mfa() == null) ? 0 : mfa().hashCode());
        hashCode = 31 * hashCode + ((versioningConfiguration() == null) ? 0 : versioningConfiguration().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutBucketVersioningRequest)) {
            return false;
        }
        PutBucketVersioningRequest other = (PutBucketVersioningRequest) obj;
        if (other.bucket() == null ^ this.bucket() == null) {
            return false;
        }
        if (other.bucket() != null && !other.bucket().equals(this.bucket())) {
            return false;
        }
        if (other.contentMD5() == null ^ this.contentMD5() == null) {
            return false;
        }
        if (other.contentMD5() != null && !other.contentMD5().equals(this.contentMD5())) {
            return false;
        }
        if (other.mfa() == null ^ this.mfa() == null) {
            return false;
        }
        if (other.mfa() != null && !other.mfa().equals(this.mfa())) {
            return false;
        }
        if (other.versioningConfiguration() == null ^ this.versioningConfiguration() == null) {
            return false;
        }
        if (other.versioningConfiguration() != null && !other.versioningConfiguration().equals(this.versioningConfiguration())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (bucket() != null) {
            sb.append("Bucket: ").append(bucket()).append(",");
        }
        if (contentMD5() != null) {
            sb.append("ContentMD5: ").append(contentMD5()).append(",");
        }
        if (mfa() != null) {
            sb.append("MFA: ").append(mfa()).append(",");
        }
        if (versioningConfiguration() != null) {
            sb.append("VersioningConfiguration: ").append(versioningConfiguration()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, PutBucketVersioningRequest> {
        /**
         * Sets the value of the Bucket property for this object.
         *
         * @param bucket
         *        The new value for the Bucket property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * Sets the value of the ContentMD5 property for this object.
         *
         * @param contentMD5
         *        The new value for the ContentMD5 property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentMD5(String contentMD5);

        /**
         * The concatenation of the authentication device's serial number, a space, and the value that is displayed on
         * your authentication device.
         * 
         * @param mfa
         *        The concatenation of the authentication device's serial number, a space, and the value that is
         *        displayed on your authentication device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mfa(String mfa);

        /**
         * Sets the value of the VersioningConfiguration property for this object.
         *
         * @param versioningConfiguration
         *        The new value for the VersioningConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versioningConfiguration(VersioningConfiguration versioningConfiguration);
    }

    private static final class BuilderImpl implements Builder {
        private String bucket;

        private String contentMD5;

        private String mfa;

        private VersioningConfiguration versioningConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PutBucketVersioningRequest model) {
            setBucket(model.bucket);
            setContentMD5(model.contentMD5);
            setMFA(model.mfa);
            setVersioningConfiguration(model.versioningConfiguration);
        }

        public final String getBucket() {
            return bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getContentMD5() {
            return contentMD5;
        }

        @Override
        public final Builder contentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
            return this;
        }

        public final void setContentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
        }

        public final String getMFA() {
            return mfa;
        }

        @Override
        public final Builder mfa(String mfa) {
            this.mfa = mfa;
            return this;
        }

        public final void setMFA(String mfa) {
            this.mfa = mfa;
        }

        public final VersioningConfiguration getVersioningConfiguration() {
            return versioningConfiguration;
        }

        @Override
        public final Builder versioningConfiguration(VersioningConfiguration versioningConfiguration) {
            this.versioningConfiguration = versioningConfiguration;
            return this;
        }

        public final void setVersioningConfiguration(VersioningConfiguration versioningConfiguration) {
            this.versioningConfiguration = versioningConfiguration;
        }

        @Override
        public PutBucketVersioningRequest build() {
            return new PutBucketVersioningRequest(this);
        }
    }
}
