/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class PutBucketAclRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<PutBucketAclRequest.Builder, PutBucketAclRequest> {
    private final String acl;

    private final AccessControlPolicy accessControlPolicy;

    private final String bucket;

    private final String contentMD5;

    private final String grantFullControl;

    private final String grantRead;

    private final String grantReadACP;

    private final String grantWrite;

    private final String grantWriteACP;

    private PutBucketAclRequest(BuilderImpl builder) {
        this.acl = builder.acl;
        this.accessControlPolicy = builder.accessControlPolicy;
        this.bucket = builder.bucket;
        this.contentMD5 = builder.contentMD5;
        this.grantFullControl = builder.grantFullControl;
        this.grantRead = builder.grantRead;
        this.grantReadACP = builder.grantReadACP;
        this.grantWrite = builder.grantWrite;
        this.grantWriteACP = builder.grantWriteACP;
    }

    /**
     * The canned ACL to apply to the bucket.
     * 
     * @return The canned ACL to apply to the bucket.
     * @see BucketCannedACL
     */
    public String acl() {
        return acl;
    }

    /**
     * Returns the value of the AccessControlPolicy property for this object.
     * 
     * @return The value of the AccessControlPolicy property for this object.
     */
    public AccessControlPolicy accessControlPolicy() {
        return accessControlPolicy;
    }

    /**
     * Returns the value of the Bucket property for this object.
     * 
     * @return The value of the Bucket property for this object.
     */
    public String bucket() {
        return bucket;
    }

    /**
     * Returns the value of the ContentMD5 property for this object.
     * 
     * @return The value of the ContentMD5 property for this object.
     */
    public String contentMD5() {
        return contentMD5;
    }

    /**
     * Allows grantee the read, write, read ACP, and write ACP permissions on the bucket.
     * 
     * @return Allows grantee the read, write, read ACP, and write ACP permissions on the bucket.
     */
    public String grantFullControl() {
        return grantFullControl;
    }

    /**
     * Allows grantee to list the objects in the bucket.
     * 
     * @return Allows grantee to list the objects in the bucket.
     */
    public String grantRead() {
        return grantRead;
    }

    /**
     * Allows grantee to read the bucket ACL.
     * 
     * @return Allows grantee to read the bucket ACL.
     */
    public String grantReadACP() {
        return grantReadACP;
    }

    /**
     * Allows grantee to create, overwrite, and delete any object in the bucket.
     * 
     * @return Allows grantee to create, overwrite, and delete any object in the bucket.
     */
    public String grantWrite() {
        return grantWrite;
    }

    /**
     * Allows grantee to write the ACL for the applicable bucket.
     * 
     * @return Allows grantee to write the ACL for the applicable bucket.
     */
    public String grantWriteACP() {
        return grantWriteACP;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((acl() == null) ? 0 : acl().hashCode());
        hashCode = 31 * hashCode + ((accessControlPolicy() == null) ? 0 : accessControlPolicy().hashCode());
        hashCode = 31 * hashCode + ((bucket() == null) ? 0 : bucket().hashCode());
        hashCode = 31 * hashCode + ((contentMD5() == null) ? 0 : contentMD5().hashCode());
        hashCode = 31 * hashCode + ((grantFullControl() == null) ? 0 : grantFullControl().hashCode());
        hashCode = 31 * hashCode + ((grantRead() == null) ? 0 : grantRead().hashCode());
        hashCode = 31 * hashCode + ((grantReadACP() == null) ? 0 : grantReadACP().hashCode());
        hashCode = 31 * hashCode + ((grantWrite() == null) ? 0 : grantWrite().hashCode());
        hashCode = 31 * hashCode + ((grantWriteACP() == null) ? 0 : grantWriteACP().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutBucketAclRequest)) {
            return false;
        }
        PutBucketAclRequest other = (PutBucketAclRequest) obj;
        if (other.acl() == null ^ this.acl() == null) {
            return false;
        }
        if (other.acl() != null && !other.acl().equals(this.acl())) {
            return false;
        }
        if (other.accessControlPolicy() == null ^ this.accessControlPolicy() == null) {
            return false;
        }
        if (other.accessControlPolicy() != null && !other.accessControlPolicy().equals(this.accessControlPolicy())) {
            return false;
        }
        if (other.bucket() == null ^ this.bucket() == null) {
            return false;
        }
        if (other.bucket() != null && !other.bucket().equals(this.bucket())) {
            return false;
        }
        if (other.contentMD5() == null ^ this.contentMD5() == null) {
            return false;
        }
        if (other.contentMD5() != null && !other.contentMD5().equals(this.contentMD5())) {
            return false;
        }
        if (other.grantFullControl() == null ^ this.grantFullControl() == null) {
            return false;
        }
        if (other.grantFullControl() != null && !other.grantFullControl().equals(this.grantFullControl())) {
            return false;
        }
        if (other.grantRead() == null ^ this.grantRead() == null) {
            return false;
        }
        if (other.grantRead() != null && !other.grantRead().equals(this.grantRead())) {
            return false;
        }
        if (other.grantReadACP() == null ^ this.grantReadACP() == null) {
            return false;
        }
        if (other.grantReadACP() != null && !other.grantReadACP().equals(this.grantReadACP())) {
            return false;
        }
        if (other.grantWrite() == null ^ this.grantWrite() == null) {
            return false;
        }
        if (other.grantWrite() != null && !other.grantWrite().equals(this.grantWrite())) {
            return false;
        }
        if (other.grantWriteACP() == null ^ this.grantWriteACP() == null) {
            return false;
        }
        if (other.grantWriteACP() != null && !other.grantWriteACP().equals(this.grantWriteACP())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (acl() != null) {
            sb.append("ACL: ").append(acl()).append(",");
        }
        if (accessControlPolicy() != null) {
            sb.append("AccessControlPolicy: ").append(accessControlPolicy()).append(",");
        }
        if (bucket() != null) {
            sb.append("Bucket: ").append(bucket()).append(",");
        }
        if (contentMD5() != null) {
            sb.append("ContentMD5: ").append(contentMD5()).append(",");
        }
        if (grantFullControl() != null) {
            sb.append("GrantFullControl: ").append(grantFullControl()).append(",");
        }
        if (grantRead() != null) {
            sb.append("GrantRead: ").append(grantRead()).append(",");
        }
        if (grantReadACP() != null) {
            sb.append("GrantReadACP: ").append(grantReadACP()).append(",");
        }
        if (grantWrite() != null) {
            sb.append("GrantWrite: ").append(grantWrite()).append(",");
        }
        if (grantWriteACP() != null) {
            sb.append("GrantWriteACP: ").append(grantWriteACP()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, PutBucketAclRequest> {
        /**
         * The canned ACL to apply to the bucket.
         * 
         * @param acl
         *        The canned ACL to apply to the bucket.
         * @see BucketCannedACL
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BucketCannedACL
         */
        Builder acl(String acl);

        /**
         * The canned ACL to apply to the bucket.
         * 
         * @param acl
         *        The canned ACL to apply to the bucket.
         * @see BucketCannedACL
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BucketCannedACL
         */
        Builder acl(BucketCannedACL acl);

        /**
         * Sets the value of the AccessControlPolicy property for this object.
         *
         * @param accessControlPolicy
         *        The new value for the AccessControlPolicy property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessControlPolicy(AccessControlPolicy accessControlPolicy);

        /**
         * Sets the value of the Bucket property for this object.
         *
         * @param bucket
         *        The new value for the Bucket property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * Sets the value of the ContentMD5 property for this object.
         *
         * @param contentMD5
         *        The new value for the ContentMD5 property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentMD5(String contentMD5);

        /**
         * Allows grantee the read, write, read ACP, and write ACP permissions on the bucket.
         * 
         * @param grantFullControl
         *        Allows grantee the read, write, read ACP, and write ACP permissions on the bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantFullControl(String grantFullControl);

        /**
         * Allows grantee to list the objects in the bucket.
         * 
         * @param grantRead
         *        Allows grantee to list the objects in the bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantRead(String grantRead);

        /**
         * Allows grantee to read the bucket ACL.
         * 
         * @param grantReadACP
         *        Allows grantee to read the bucket ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantReadACP(String grantReadACP);

        /**
         * Allows grantee to create, overwrite, and delete any object in the bucket.
         * 
         * @param grantWrite
         *        Allows grantee to create, overwrite, and delete any object in the bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantWrite(String grantWrite);

        /**
         * Allows grantee to write the ACL for the applicable bucket.
         * 
         * @param grantWriteACP
         *        Allows grantee to write the ACL for the applicable bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantWriteACP(String grantWriteACP);
    }

    private static final class BuilderImpl implements Builder {
        private String acl;

        private AccessControlPolicy accessControlPolicy;

        private String bucket;

        private String contentMD5;

        private String grantFullControl;

        private String grantRead;

        private String grantReadACP;

        private String grantWrite;

        private String grantWriteACP;

        private BuilderImpl() {
        }

        private BuilderImpl(PutBucketAclRequest model) {
            setACL(model.acl);
            setAccessControlPolicy(model.accessControlPolicy);
            setBucket(model.bucket);
            setContentMD5(model.contentMD5);
            setGrantFullControl(model.grantFullControl);
            setGrantRead(model.grantRead);
            setGrantReadACP(model.grantReadACP);
            setGrantWrite(model.grantWrite);
            setGrantWriteACP(model.grantWriteACP);
        }

        public final String getACL() {
            return acl;
        }

        @Override
        public final Builder acl(String acl) {
            this.acl = acl;
            return this;
        }

        @Override
        public final Builder acl(BucketCannedACL acl) {
            this.acl(acl.toString());
            return this;
        }

        public final void setACL(String acl) {
            this.acl = acl;
        }

        public final AccessControlPolicy getAccessControlPolicy() {
            return accessControlPolicy;
        }

        @Override
        public final Builder accessControlPolicy(AccessControlPolicy accessControlPolicy) {
            this.accessControlPolicy = accessControlPolicy;
            return this;
        }

        public final void setAccessControlPolicy(AccessControlPolicy accessControlPolicy) {
            this.accessControlPolicy = accessControlPolicy;
        }

        public final String getBucket() {
            return bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getContentMD5() {
            return contentMD5;
        }

        @Override
        public final Builder contentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
            return this;
        }

        public final void setContentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
        }

        public final String getGrantFullControl() {
            return grantFullControl;
        }

        @Override
        public final Builder grantFullControl(String grantFullControl) {
            this.grantFullControl = grantFullControl;
            return this;
        }

        public final void setGrantFullControl(String grantFullControl) {
            this.grantFullControl = grantFullControl;
        }

        public final String getGrantRead() {
            return grantRead;
        }

        @Override
        public final Builder grantRead(String grantRead) {
            this.grantRead = grantRead;
            return this;
        }

        public final void setGrantRead(String grantRead) {
            this.grantRead = grantRead;
        }

        public final String getGrantReadACP() {
            return grantReadACP;
        }

        @Override
        public final Builder grantReadACP(String grantReadACP) {
            this.grantReadACP = grantReadACP;
            return this;
        }

        public final void setGrantReadACP(String grantReadACP) {
            this.grantReadACP = grantReadACP;
        }

        public final String getGrantWrite() {
            return grantWrite;
        }

        @Override
        public final Builder grantWrite(String grantWrite) {
            this.grantWrite = grantWrite;
            return this;
        }

        public final void setGrantWrite(String grantWrite) {
            this.grantWrite = grantWrite;
        }

        public final String getGrantWriteACP() {
            return grantWriteACP;
        }

        @Override
        public final Builder grantWriteACP(String grantWriteACP) {
            this.grantWriteACP = grantWriteACP;
            return this;
        }

        public final void setGrantWriteACP(String grantWriteACP) {
            this.grantWriteACP = grantWriteACP;
        }

        @Override
        public PutBucketAclRequest build() {
            return new PutBucketAclRequest(this);
        }
    }
}
